/*
 *	CALC.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

 // Berechnungen für CTREK




// Sektordaten aus Universum für Position qx,qy ermitteln
// und im Sektor eintragen
void FillSector() {
    int ix, iy;
    int i;
    // Ermittelte Sektorposition
    int px, py;
    // Zufallszahl
    double ra;
    // Anzahl Klingonen, Bases, Sterne im Sektor, Planet
    int quadkl, quadsb, quadst, quadpl; 
    // Sektoren löschen
    for (iy = 0; iy <= 10; iy++) {
        for (ix = 0; ix <= 10; ix++) {
            Sektor[ix][iy] = ES;
        }
    }
    // Raumschiff platzieren
    Sektor[sx][sy] = RS;

    // Klingonen platzieren, wenn vorhanden
    // lokale Klingonenpositionen und Energie löschen
    // klpos [i][0] = x; 
    // klpos [i][1] = y; 
    // klpos [i][2] = Energie;
    // klpos [i][3] = 0 inaktiv, 1 aktiv 
    for (i = 0; i < 3; i++) {
        klpos[i][0] = 0; 
        klpos[i][1] = 0;
        klpos[i][2] = 0;
        klpos[i][3] = 0;
    }
    // Zufallsgenerator neu starten
    srand((unsigned) _gettime());

    // Klingonenanzahl aus aktuellem Quadranten auslesen
    quadkl = 0;
    quadkl = (int)Universum[qx][qy] / 100;
    // klcountquad wird für Phaser benötigt
    klcountquad = quadkl;
    //printf("\nQuadrant(%d,%d): %d\n",qx,qy,Universum[qx][qy]);
    //printf("Klingonen: %d\n",quadkl);
    // Wenn Klingonen > 0 dann in Quadrant einsetzen
    while (quadkl > 0) {
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        px = (int)ra;
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        py = (int)ra;
        if (Sektor[px][py] == ES) {
            Sektor[px][py] = KS;
            //printf("Klingone x=%d,y=%d,ID %d\n",px,py,KS);
            klpos[quadkl][0] = px;
            klpos[quadkl][1] = py;
            klpos[quadkl][2] = klshield;
            klpos[quadkl][3] = 1; 
            //printf("Klingone Nr. %d auf x=%d,y=%d, Energie=%d\n",quadkl,klpos[quadkl][0],klpos[quadkl][1],klpos[quadkl][2]);
            //printf("Sektorinhalt(x,y): %d\n",Sektor[px][py]);
            quadkl--;
        }
    }
    // Starbases eintragen, wenn vorhanden

    // Starbases stehen an 10er Stelle im Quadrant
    quadsb = 0;
    quadsb = (Universum[qx][qy] / 10) % 10;
    // Korrektur, wenn zuviele Basen im Quadranten eingetragen sind
    if (quadsb > 1) quadsb = 1;

    //printf("Basen: %d\n",quadsb);
    while (quadsb > 0) {
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        px = (int) ra;
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        py = (int) ra;
        if (Sektor[px][py] == ES) {
            Sektor[px][py] = BS;
            //printf("Basis x=%d,y=%d,Wert %d\n",px,py,Sektor[px][py]);
            quadsb--;
        }
    }
    // Sterne im Sektor eintragen
    quadst = 0;
    quadst = Universum[qx][qy] % 10;
    //printf("Sterne: %d\n",quadst);
    while (quadst > 0) {
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        px = (int) ra;
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        py = (int) ra;
        if (Sektor[px][py] == ES) {
            Sektor[px][py] = SS;
            //printf("Stern x=%d,y=%d,Wert %d\n",px,py,Sektor[px][py]);
            quadst--;
        }
    }
    // Planeten für Exkursion eintragen

    // Maximal ein Planet pro Quadrant
    quadpl = 0;
    ra = (double)rand() / RAND_MAX;
    if (ra > 0.90) quadpl = 1;
    while (quadpl > 0) {
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        px = (int) ra;
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        py = (int) ra;
        if (Sektor[px][py] == ES) {
            Sektor[px][py] = PS;
            //printf("Stern x=%d,y=%d,Wert %d\n",px,py,Sektor[px][py]);
            quadpl--;
        }
    }
     

}


// Long-Range-Sektor Daten berechnen
void FillLRS() {
    // LRS berechnen und füllen
    // LRS[10] -> [1],[2],[3]
    //            [4],[5],[6]  
    //            [7],[8],[9]
    // LRS[5] ist aktueller Quadrant 
    int i;
    int xl,xr,yo,yu;
    // LRS zurücksetzen
    for (i=1;i<10;i++) {
        LRS[i] = LRSOUT;
    } 
    // Wenn LRS Schaden > 50 %, dann keine Anzeige
    if (damlrs < 50) return;
    // Ober und Untergrenzen festlegen
    xl = qx - 1;
    xr = qx + 1;
    yo = qy + 1;
    yu = qy - 1;
    // LRS[5] ist aktueller Quadrant
    LRS[5] = Universum[qx][qy];
    // Aktuellen Quadranten im kumulativen Universum bekanntgeben
    KumUniversum[qx][qy] = Universum[qx][qy];
    if (xl >= 0) {
        LRS[4] = Universum[xl][qy];
        KumUniversum[xl][qy] = Universum[xl][qy];
    }
    if (xr <= 9) {
        LRS[6] = Universum[xr][qy];
        KumUniversum[xr][qy] = Universum[xr][qy];
    }
    if (yo <= 9) {
        LRS[2] = Universum[qx][yo];
        KumUniversum[qx][yo] = Universum[qx][yo];
    }
    if (yu >= 0) {
        LRS[8] = Universum[qx][yu];
        KumUniversum[qx][yu] = Universum[qx][yu];
    }
    if ((xl >= 0) && (yo <= 9)) {
        LRS[1] = Universum[xl][yo];
        KumUniversum[xl][yo] = Universum[xl][yo];
    }
    if ((xl >= 0) && (yu >= 0)) {
        LRS[7] = Universum[xl][yu];
        KumUniversum[xl][yu] = Universum[xl][yu];
    }
    if ((xr <= 9) && (yo <= 9)) {
        LRS[3] = Universum[xr][yo];
        KumUniversum[xr][yo] = Universum[xr][yo];
    }
    if ((xr <= 9) && (yu >= 0)) {
        LRS[9] = Universum[xr][yu];
        KumUniversum[xr][yu] = Universum[xr][yu];
    }
}

// Berechnungsprogramme für Energie und Zeit

int CalcEnergy(int fun, int value) {
    // Energieberechnung für verschiedene Funktionen
    // und Anzeige der Ergebnisse am Hauptschirm
    // Warp Energiebedarf rechnet sich aus Distanz und Warpfaktor
    int erg;
    int retvalue;
    retvalue = 1;
    // Energieverbrauch für WARP
    if (fun == WARP) {
        // Ist noch genügend Gesamtenergie energy vorhanden
        if ((energy - value) < 0) {
            WriteMessageLine("Energie reicht nicht aus!");
            retvalue = 0;
        } else {
            // Energiebedarf von Gesamtenergie abziehen
            energy -= value;
        }
    }
    // Energieverbrauch für IMPULSANTRIEB
    if (fun == IMPULS) {
        // erg (Bedarf) = distanz * IMPULSFAKTOR (Default = 3)
        erg = value * IMPULSFAKTOR;
        // Ist noch genügend Gesamtenergie energy vorhanden
        if ((energy - erg) < 0) {
            WriteMessageLine("Energie reicht nicht aus!");
            retvalue = 0;
        } else {
            // Energiebedarf von Gesamtenergie abziehen
            energy -= erg;
        }
    }
    // Return 1 - Energie vorhanden und abgerechnet
    return retvalue;
}




int CalcTime(double value) {
    // Zeitberechnung für Spielablauf
    // Jede Aktion benötigt Zeit und ist vom Faktor abhängig
    // Standardzeit = 0.05 Sternetage pro Aktion (TIMEUNIT)
    // WARP = Distanz * TIMEUNIT / Warpfaktor
    // IMPULS = TIMEUNIT

    double erg;
    int retvalue;
    retvalue = 1;

    // erg = Eingabewert * TIMEUNIT (Default 0.05)
    erg = value * TIMEUNIT;
    // Ist noch genügend Gesamtenergie energy vorhanden
    if ((gametime - erg) < 0) {
        WriteMessageLine("Spielzeit reicht nicht aus!");
        // Spielzeit zu gering, Spielbeenden in Kommandoschleife
        gametime = 0;
        retvalue = 0;

    } else {
        // Zeitbedarf von Spielzeit (Restzeit) abziehen
        gametime -= erg;
        // Zeitbedarf auf Sternzeit aufaddieren
        stardate += erg;
    }
    // Return 1 - Energie vorhanden und abgerechnet
    return retvalue;
}

// Schäden an Raumschiff nach ANgriff Klingonen berechnen
// Summe der Schussenergie vom Klingonenangriff aus attack.c KlingonAttack verrechnen
// Maximale Schussenergie bei geringstem Abstand je Klingone ist MAXKLINGONPHASER (Default 100)
// Der Abstand der Schussentfernung wird berücksichtigt MAXKLINGONPHASER / abst
// Schadensreihenfolge
// - Wenn Schilde oben sind:
// Schussenergie wird 1:1 von Schildenergie abgezogen
// - Wenn Schilde 0 
// 1. Schäden an L-R Sensor
// 2. Schäden an Warp Antrieb
// 3. Schäden an Torpedos
// 4. Schäden an Phaser
// 5. Schäden an Schilde
// 6. Schäden an Impulsantrieb
// 7. Schäden an Computer
// Je 100 Energieeinheiten aus Trefferenergie werden 10% Schäden verursacht 
void CalcDamage(int damage) {
        // Zufallszahl
    double ra;
    ra = 0.0;
    int ag;
    ag = 0;
    int dam;
    dam = 0;
    // Zufallsgenerator neu starten
    srand((unsigned) _gettime());

    // Wenn Schilde oben, dann erst Energie von Schilden abziehen
    if (shield > 0) {
        shield -= damage;
        if (shield < 0) shield = 0;
    } else {
        // Keine Schilde, Schäden berechnen
        // Zufallszahl zur Ermittlung des beschädigten Aggregats
        ra = (double)rand() / RAND_MAX * 9.0 + 1;
        ag = (int)ra;
        dam = damage / 10;
        switch(ag) {
            case 1: // LRS, volle Energie bei Treffer
                damlrs -= damage;
                if (damlrs < 0) damlrs = 0;
                if (damlrs < 50) {
                    FillLRS();
                    ShowLRS();
                }    
                break;
            case 2: // WARP
                damwarp -= dam;
                if (damwarp < 0) damwarp = 0;
                break;
            case 3: // TORPEDOS
                damtorp -= dam;
                if (damtorp < 0) damtorp = 0;
                break;
            case 4: // PHASER
                damphaser -= dam;
                if (damphaser < 0) damphaser = 0;
                break;
            case 5: // Schilde
                damshield -= dam;
                if (damshield < 0) damshield = 0;
                break;
            case 6: // IMPULSANTRIEB
                damimp -= dam;
                if (damimp < 0) damimp = 0;
                break;
            case 7: // COMPUTER
                damcomp -= dam;
                if (damcomp < 0) damcomp = 0;
                break;
        }

    }
    return;
}

void CalcRepair(int zeit) {
    // Schiffsreparatur abhängig von Tage für alle Aggregate
    // Eine TimeUnit bringt 2% Reparatur * zeit
    // Ein Tag sind 20 TIMEUNITS
    double erg;
    // erg = Eingabewert * TIMEUNIT (Default 0.05)
    erg = (int)(zeit * TIMEUNIT * 100 * 2 / 5);
    // LRS
    if (damlrs < 100) damlrs += erg;
    if (damlrs > 100) damlrs = 100;
    if (damlrs >= 50) {
        FillLRS();
        ShowLRS();
    }
    // WARP
    if (damwarp < 100) damwarp += erg;
    if (damwarp > 100) damwarp = 100;
    // TORPEDOS
    if (damtorp < 100) damtorp += erg;
    if (damtorp > 100) damtorp = 100;
    // PHASER
    if (damphaser < 100) damphaser += erg;
    if (damphaser > 100) damphaser = 100;
    // SCHILDE
    if (damshield < 100) damshield += erg;
    if (damshield > 100) damshield = 100;
    // IMPULSANTRIEB
    if (damimp < 100) damimp += erg;
    if (damimp > 100) damimp = 100;
    // COMPUTER
    if (damcomp < 100) damcomp += erg;
    if (damcomp > 100) damcomp = 100;

    return;

}



