/*
 *	COMPUTER.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

 // Computer

void Computer() {
    // Auswahl der Computerfunktionen
    // 1 = Suche nächste Basis
    // 2 = Zeige erforschtes Universum
    // 3 = Nothilfe, Anfordern von Hilfsenergie
    char key = 0;
    //char ukey = 0;
    int ende = 0;
    ClearCommandLine();
    ClearMessageLine();
    while (ende == 0) {
        WriteScreenxy(12,22, "Computer: Funktion waehlen");
        key = GetOneKeyAtXY(39,22);
        switch(key) {
            case '1':
                // Suche nächste Basis
                ComputerNextBase();
                ende = 1;
                break;
            case '2':
                // Zeige erforschtes Universum
                ComputerUniversum();
                ende = 1;
                break;
            case '3':
                // Zeige erforschtes Universum
                ComputerNothilfe();
                ende = 1;
                break;
            case RETURN:
                // Computer beenden
                ende = 1;
                break;    
            case ESC:
                // Computer beenden
                ende = 1;
                break;    
            default: // Keine Gültige Eingabe oder Abbruch
                ende = 0;
                key = 0;
                break;
        }
    }
    ClearCommandLine();
    ClearMessageLine();

    return;
}

void ComputerNextBase() {
    // Computer -> Anzeige der Basenstandorte
    // Bildschirm löschen
    gp_clearscreen();
    gp_cursor_off();
    char message[50];

    // LongRangeSektor anzeigen
    int ix,iy,x,y;
    x = 10;
    y = 3;
    WriteScreenxy(26,0,"Bekannte Basen im Universum");
    WriteScreenxy(10,1,"-0-   -1-   -2-   -3-   -4-   -5-   -6-   -7-   -8-   -9-");
    DrawLine(54,230,408,230);
    DrawLine(54,230,54,30);
    DrawLine(408,230,408,30);
    DrawLine(54,30,408,30);

    // Anzeige
    for (iy=9;iy>=0;iy--) {
        SetCursorxy(4,y);
        printf("-%d-",iy);
        for (ix = 0; ix < 10; ix++) {
        SetCursorxy(x,y);
        if ((Universum[ix][iy] / 10 % 10) == 0) {
            //Quadranten ohne Starbase
                    // Raumschiff Quadrant anzeigen
            if (qx == ix && qy == iy) {
                printf("%s", RSYMB);
            } else {
                printf("%s",LRSOUTSYMB);
            }
        } else {
            //  Quadranten des Universums mit Starbase
            printf("%03d",Universum[ix][iy]);
        }
        x += 6;    
        }
        y += 2;
        x = 10;
    }
    // EIngabe und Nachrichten
    sprintf(message,"Raumschiff in Quadrant (%d,%d). Weiter mit Taste...",qx,qy);
    WriteScreenxy(2,23, message);
    // Return oder Taste für weiter
    GetOneKeyAtXY(54,23);
    // Spielbildschirm wieder hertellen
    ShowScreen();
    // ShortRangesensor anzeigen 
    ShowSRS();
    // LongRangeSensor anzeigen
    ShowLRS();
    // Daten und Info anzeigen
    ShowInfo();
    return;

}


void ComputerUniversum() {
    // Computer -> Anzeige erforschtes Universum
    // Bildschirm löschen
    gp_clearscreen();
    gp_cursor_off();
    char message[50];

    // LongRangeSektor anzeigen
    int ix,iy,x,y;
    x = 10;
    y = 3;
    WriteScreenxy(28,0,"Erforschtes Universum");
    WriteScreenxy(10,1,"-0-   -1-   -2-   -3-   -4-   -5-   -6-   -7-   -8-   -9-");
    DrawLine(54,230,408,230);
    DrawLine(54,230,54,30);
    DrawLine(408,230,408,30);
    DrawLine(54,30,408,30);

    // Anzeige
    for (iy=9;iy>=0;iy--) {
        SetCursorxy(4,y);
        printf("-%d-",iy);
        for (ix = 0; ix < 10; ix++) {
        SetCursorxy(x,y);
        if (KumUniversum[ix][iy] == 0) {
            // Nicht erforschte Quadranten des Universum
            printf("%s",LRSOUTSYMB);
        } else {
            // Erforschte Quadranten des Universums
            printf("%03d",KumUniversum[ix][iy]);
        }
        x += 6;    
        }
        y += 2;
        x = 10;
    }
    // EIngabe und Nachrichten
    sprintf(message,"Raumschiff in Quadrant (%d,%d). Weiter mit Taste...",qx,qy);
    WriteScreenxy(2,23, message);
    // Return oder Taste für weiter
    GetOneKeyAtXY(54,23);
    // Spielbildschirm wieder hertellen
    ShowScreen();
    // ShortRangesensor anzeigen 
    ShowSRS();
    // LongRangeSensor anzeigen
    ShowLRS();
    // Daten und Info anzeigen
    ShowInfo();
    return;
} 


void ComputerNothilfe() {
    // Nothilfe, 200 Energie von Hilfsschiff
    // kann maximal 3 mal in Anspruch genommen werden
    notcount -= 1;
    if (notcount > 0) {
        energy += NOTENERGY;
        if (energy > MAXENERGY) energy = MAXENERGY;
        WriteMessageLine("Energie von Hilfsschiff geladen. Taste...");
        gp_ci();
        return;
    } else {
        WriteMessageLine("Nothilfe nicht mehr moeglich. Taste...");
        gp_ci();
        return;
    }
}

