/*
 *	CTREK.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */


#include "ctrek.h"



int main()
{
    setbuf(stdout,NULL);
    setbuf(stdin,NULL);
    // Spiel initialisieren
    InitGame();
    // Universum einrichten
    InitUniversum();
    // Sektordaten für SRS füllen
    FillSector();
    // LongRangeSektor Daten füllen
    FillLRS();
    // Hauptbildschirm anzeigen
    ShowScreen();
    // ShortRangesensor anzeigen 
    ShowSRS();
    // LongRangeSensor anzeigen
    ShowLRS();
    // Daten und Info anzeigen
    ShowInfo();
    // Haupthilfe anzeigen
    ShowHilfe(0);
    // Kommandoeingabe und Hauptschleife
    Kommando();
    // Kommandoebene mit (Q)uit verlassen
    // Ergebnisanzeige
    // Bildschirm löschen vor Ende und Curso einschalten
    gp_clearscreen();    
    gp_cursor_on();
    return 0;
} 

// Kommandoeingabe und Programmhauptschleife
void Kommando() {
    char key = 0;
    //char ukey = 0;
    int ende = 0;
    while (ende == 0) {
        //if (gp_csts()) {
            key = GetOneKeyAtXY(12,22);
            switch(key) {
                case 'w':
                    ShowHilfe(1);
                    Warp();
                    ClearHilfe();
                    break;
                case 'p':
                    ShowHilfe(3);
                    Phaser();
                    ClearHilfe();
                    break;
                case 't':
                    ShowHilfe(4);
                    Torpedo();
                    ClearHilfe();
                    break;
                case '+': // Schilde + 200
                    Shield(1);
                    ClearHilfe();
                    break;
                case '-': // Schilde - 200 
                    Shield(0);
                    ClearHilfe();
                    break;
                case 'r':
                    ShowHilfe(6);
                    Repair();
                    ClearHilfe();
                    break;
                case 'e':
                    ShowHilfe(7);
                    DiscoverPlanet();
                    ClearHilfe();
                    break;
                case 'c':
                    ShowHilfe(8);
                    Computer();
                    ClearHilfe();
                    break;
                case LEFT:
                    //Impulsantrieb links
                    MoveImpuls(4);
                    break;
                case RIGHT:
                    //Impulsantrieb rechts
                    MoveImpuls(6);
                    break;
                case UP:
                    //Impulsantrieb hoch
                    MoveImpuls(8);
                    break;
                case DOWN:
                    //Impulsantrieb runter
                    MoveImpuls(2);
                    break;
                case 'q':
                    ShowHilfe(9);
                    ClearMessageLine();
                    WriteScreenxy(12,22, "Spiel beenden mit 'J' ?");
                    key = GetOneKeyAtXY(36,22);
                    if (key=='j') ende = 1;
                    ClearHilfe();
                    break;
                default: // Keine Gültige Eingabe oder Abbruch
                    ClearHilfe();
                    ShowHilfe(0);
                    ClearMessageLine();
                    break;
            }
            // Spielende prüfen
            if((klcount <= 0) || (gametime <= 0) || (energy <= 0)) {
                if (klcount <= 0) {
                    // Spiel gewonnen
                    WriteScreenxy(12,22, "Spiel gewonnen! Taste...");
                }
                if (gametime <= 0) {
                    WriteScreenxy(12,22, "Spiel verloren. Zeit abgelaufen. Taste...");
                }
                if (energy <= 0) {
                    WriteScreenxy(12,22, "Spiel verloren. Energie verbraucht. Taste...");
                }
                gp_ci();
                ende = 1;
            }
             
        //}
    }
}



int GetParamAtXY(uint8_t x0, uint8_t y0, int min_value, int max_value, uint8_t max_digits, const char* const p_str) {
    // Ausgabe Text an Position X, Y
    // Rückgabe muss zwischen min und max sein
    // Rückgabe INT wert
    int param;
    uint8_t x1;
    uint8_t y1;
    char c;
    int digits;
    size_t laenge;
    laenge = strlen(p_str);
    //printf("Laenge String: %d\n",laenge);
    x1 = x0 + (uint8_t)laenge + 1;
    y1 = y0;
    WriteScreenxy(x0,y0,p_str);
    // Abfrage
    digits = 0;
    param = 0;
    //for (i=1;i<=max_digits;i++) {
    while (digits <= max_digits) {
        if (digits == 0) 
           WriteScreenxy((uint8_t)x1,(uint8_t)y1,"    "); //<- hier
        c = GetOneKeyAtXY(x1,y1);
        // Return
        if (c == 13) {
            if (param < min_value) return -1;
            return param;
        }
        digits++;
        // ESC
        if (c == 27) return -1;
        // Prüfung auf Zahl
        if (c < '0' || c > '9') {
            WriteScreenxy(x1,y1," "); //<- hier
            digits--;
        } else {
            param = param * 10 + (c - '0');
            //SetCursorxy((uint8_t) x1,(uint8_t) y1);
            //printf("%s",&c);
            WriteScreenxy((uint8_t) x1,(uint8_t) y1,&c);
            x1++;
        }
        // Prüfung auf Min und Max
        if (param < min_value || param > max_value) {
            param = 0;
            x1 = x0 + (int)laenge + 1;
            digits = 0;
        }
        // Prüfung auf Eingabelänge 
        if (digits == max_digits) {
            return param;
        }
    }
    return param;
}


char GetOneKeyAtXY(uint8_t x0,uint8_t y0) {
    // Ein Zeichen an der Position x0,y0 erfassen
    
    char key, ukey;
    key = 0;
    ukey = 0;
    SetCursorxy(x0,y0);
    gp_setflip(10u,0u);
    gp_cursor_on();
    key = gp_ci();
    ukey = (char)toupper((int) key);
    WriteScreenxy(x0,y0, &ukey);
    gp_cursor_off();            
    //gp_setflip(10u,10u);
    return key;
}

