/*
* Headerdatei zu CTREK
*/

// Headerdateien
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <math.h>
#include <ndrcomp/target.h>
#include <ndrcomp/sysclock.h>
#include <sys/ndrclock.h>
#include "../../nkc_common/nkc/nkc.h"



// Definition globaler Variablen
// Universum
int Universum[10][10];
// Sektor
int Sektor[10][10];
// kumulatives Universum für Computer - Universum Anzeige
int KumUniversum[10][10];


// Anzahl Klingonen und Basisstationen (Starbases) im Spiel
int sumkl;
int sumsb;

// Symbole für Sektoranzeige SRS (ShortRageSector)
// Leerer Sektorplatz
#define ESYMB " . "
#define ES 0
// Raumschiff
#define RSYMB "<R>"
#define RS 1
// Klingone
#define KSYMB "<K>"
#define KS 2
// Raumbasis
#define BSYMB "<B>"
#define BS 3
// Planet
#define PSYMB "<P>"
#define PS 4
// Stern
#define SSYMB " * "
#define SS 5

// LRS Array und Felder ausserhalb Universum
#define LRSOUTSYMB "---"
#define LRSOUT 0
// LongRangSektor Array, 
int LRS[10];

// Schaden, Damage Startwert = 100 %
// MAximaler Schaden, damit ein Aggregat verfügbar
#define MAXDAM 50
// Startwerte, alle Aggregate sind voll funktionsfähig
int damwarp = 100;
int damimp = 100;
int damlrs = 100;
int damshield = 100;
int damphaser = 100;
int damtorp = 100;
int damcomp = 100;


// Nothilfe, kann im Computer angefordert werden, wenn Energie verbraucht
// Nothilfe kann maximal 3x im Spiel angewendet werden
int notcount = 3;
// Vomm Hilfsschiff übertragene Energie
#define NOTENERGY 300

// Startwerte
// Zeit
// Sternzeit wird zu Beginn in init.c neu bestimmt. Eine reine Infoanzeige
double stardate0 = 3000.0;  
double stardate = 3000.0;
// Spielzeit Default, wird in init.c mit Anzahl von Klingonen neu bestimmt
double gametime = 30.0;
// Zeiteinheit für Abrechnung von Aktionen
#define TIMEUNIT 0.03

// Energie des Raumschiffs
float energy = 3000.0;
// Maximale Energie, die zu Beginn und nach Andocken an Raumbasis zur Verfügung steht
#define MAXENERGY 3000.0

// Energiebedarf bei Impulsantrieb
#define IMPULSFAKTOR 3

// Phaser
// maximale Phaserenergie pro Schuss
#define MAXPHASER 200
// maximale Abstand für Treffer muss kleiner 5 sein
// Jeder Gitter-/Sektorabstand führt zu 20% Abnahme bei der Schussenergie
#define MAXPHASERDIST 5

// Torpedos, Anzahl zu Spielbeginn und nach Andocken an Raumbasis
int torp = 10;

// Schildenergie
#define MAXSHIELD 1000
#define SHIELDINC 200
int shield = 0;

// Condition -> ANzeige in Info ALARMSTATUS
#define CONDGREEN "Green "
#define CONDRED   "*RED* "
#define CONDDOCK  "Docked"
#define CONDORBIT "Orbit "

// Raumschiff im Orbit um einen Planeten (0 = kein Orbit, 1 = Orbit)
// Im Orbit kann eine Exkursion gestartet werden, um Dilithium zu finden
int orbit = 0;

// Variable für Anzeige des Alarmstatus mit Standardwert green
char condition[8] = CONDGREEN;

// Klingonen daten im aktuellen Quadranten
// Im Sektor maximal 3 Klingonen mit Position x,y und Energie
// klpos[][0] = x
// klpos[][1] = y
// klpos[][2] = Energie
// klpos[][3] = 0 zerstört, 1 = aktiv
int klpos[3][4];
// Standardenergie für Klingonenraumschiffe, Wenn <= 0, Klingone zerstört
int klshield = 200;
// Anzahl Klingonen im Spiel
int klcount;
// Anzahl Klingonen im Quadranten
int klcountquad;
// Beginn de wirksamen Schussentfernung durch Klingonen
#define MAXKLINGONDIST 5
// Maximale Feuerkraft der Klingonen, Schiffe sind kleiner, Feuerkraft geringer 
#define MAXKLINGONPHASER 100




// Quadrant und Sektor für Position Raumschiff
// (x = horizontal, Ursprung links 0)
// (y = vertikal, Ursprung unten 0)
// Vorbelegungen mit 0 zu Beginn
int qx = 0;
int qy = 0;
// Aktuelle Position des Raumschiffs im Sektor
int sx = 0;
int sy = 0;
// Letzte Position
int psx = 0;
int psy = 0;



// Pfeiltasten, Return und ESC für Steuerung
#define UP    0x05u
#define DOWN  0x18u
#define LEFT  0x13u
#define RIGHT 0x04u
#define RETURN 0x0Du
#define ESC 0x1Bu

// Kommandozuordnungen für Zeit- und Energieberechnungen
#define WARP 1
#define IMPULS 2
#define PHASER 3
#define TORPEDOS 4
#define SCHILDE 5
#define REPARATUR 6
#define PLANET 7
#define COMPUTER 8




// Berechnungen

// Für Impuls und Warpantrieb die Verschiebung in Quadrant und Sektor berechnen
// WIDTH und HEIGHT sind die Abmessungen des Universums
// Werden benötigt für die Torusberechnung 
// Überschreiten der Grenzen führt zum Wiedereinsetzen an der Gegenseite
#define WIDTH 100
#define HEIGHT 100
#define FP 256.0 //(double) 2^8 als Näherungsweise Genauigkeit für isine, icos

// Sinusfunktion aus Grundprogramm
double isin(double deg) {
    //double FP = 256.0;
    double sin;
    sin = gp_sin(deg) / FP;
    return sin;
}
// COS Näherung aus Grundprogramm
double icos(double deg) {
    //double FP = 256.0;
    double cos;
    cos = gp_cos(deg) / FP;
    return cos;
}


// Double zu Integer runden
int iround(double x) {
    return (x >= 0) ? (int)(x + 0.5) : (int)(x - 0.5);
}



// Zufallszahl zwischen 0 und 1
double RandomOne() {
    double random_number = (double)rand() / RAND_MAX;
    return random_number;
}

// Funktionen für Berechnungen in der Matrix

// sqrt in math.h nicht enthalten, nicht gefunden
// Eine reine Integerfunktion
double sqrt(double val) {
    // Quadratwurzel integer
    if (val == 0 || val == 1)
    return val;

    int counter = 1; 
    int sqroot=1;
    while (sqroot <= val) {
        counter++;
        sqroot = counter*counter;
    }
    return counter - 1;
}

// Abstandsberechnung im Koordinatensystem zwischen sx,sy und kx,ky
int abstand(int sx,int sy,int kx,int ky) {
    // Abstand zwischen Raumschiff und Klingone oder Objekt
    return (int)fabs(sqrt(pow((kx-sx),2)+pow((ky-sy),2)));
}



// Funktionsprototypen
void InitGame(void);
void InitUniversum(void);
void FillSector(void);
void ShowScreen(void);
void ClearInfo(void);
void ShowInfo(void);
void ShowSRS(void);
void FillLRS(void);
void ShowLRS(void);
char GetOneKeyAtXY(uint8_t x0,uint8_t y0);
void ClearCommandLine(void);
void WriteMessageLine(const char* const p_str);
void ClearMessageLine(void);
void Kommando(void);
void CheckDocking(void);
void DiscoverPlanet(void);
void ComputerUniversum(void);
void ComputerNextBase(void);
void ComputerUniversum(void);
void ComputerNothilfe(void);
int CalcEnergy(int fun, int value);
int CalcTime(double value);
void CalcDamage(int damage);
void CalcRepair(int zeit);
void ClearHilfe(void);
void Repair(void);
void ShowHilfe(int Index);
void Warp(void);
void Shield(int value);
void Phaser(void);
void Torpedo(void);
void KlingonAttack(void);
void CalcDamage(int damage);
void MoveImpuls(int direction);
void MoveWarp(int distance, int angle);
int GetParamAtXY(uint8_t x0, uint8_t y0, int min_value, int max_value, uint8_t max_digits, const char* const p_str);

// Module
#include "gdp.h"
#include "init.c"
#include "calc.c"
#include "display.c"
#include "help.c"
#include "move.c"
#include "tools.c"
#include "computer.c"
#include "phaser.c"
#include "attack.c"
#include "torpedos.c"



