/*
 *	DISPLAY.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

// CTREK Unterprogramm für Bildschrimanzeige



void ClearCommandLine() {
    //Kommandozeile löschen (50 Zeichen)
    WriteScreenxy(12,22, "                                                         ");
}

void ClearMessageLine() {
    //Kommandozeile löschen (56 Zeichen)
    WriteScreenxy(12,23, "                                                             ");
}

void WriteMessageLine(const char* const p_str) {
    // Schreibe Nachricht in Zeile
        ClearMessageLine();
        WriteScreenxy(13,23, p_str);
}


// Anzeige Long-Range-Sektor
void ShowLRS() {
    // LongRangeSektor anzeigen
    int i,x,y;
    x = 33;
    y = 2;
    
    // Anzeige
    for (i=1;i<10;i++) {
        SetCursorxy(x,y);
        if (LRS[i] == 0) {
            // Ausserhalb Universum
            printf("%s",LRSOUTSYMB);
        } else {
            // Innerhalb Universum
            printf("%03d",LRS[i]);
        }
        // Zeilen und Spalten für Ausgabe neu berechnen
        if (x == 45) {
            y = y + 2;
            x = 33;
        } else {
            x = x + 6;
        }

    }

}


// Anzeige Short-Range-Sektor
void ShowSRS() {
    int ix,iy;
    int x,y;
    int feld;

    x = 25;
    y = 20;
    feld = 0;
    for (iy = 0; iy < 10; iy++) {
        for (ix = 0; ix < 10; ix++) {   
            SetCursorxy(x,y);
            feld = Sektor[ix][iy];
            switch(feld) {
                case 0: printf("%s",ESYMB);
                        break;
                case 1: printf("%s",RSYMB);
                        break;
                case 2: printf("%s",KSYMB);
                        break;
                case 3: printf("%s",BSYMB);
                        break;
                case 4: printf("%s",PSYMB);
                        break;
                case 5: printf("%s",SSYMB);
                        break;
            }
            //printf(" %d",Sektor[ix][iy]);
            x = x + 3;
        }
        x = 25;
        y = y - 1;
    }
        // Für Alarmstatus auf Klingonen prüfen
    // Klingonen vorhanden?, 100er Stelle im Universum abfragen
    if ((Universum[qx][qy] / 100) > 0) {
        // Klingonen im Sektor, Alarmstatus rot
        strcpy(condition,CONDRED);
        // Alarmstufe rot überschreibt alles
        return;
    }

}

void ClearInfo() {
    // Infozeile löschen
    int s,i;
    // Spalte der Anzeige
    s = 72;
    i = 2;
    for (i = 2; i <= 10; i++) {
    SetCursorxy(s,i);
    printf("      ");
    }
    for (i = 14; i <= 19; i++) {
    SetCursorxy(s,i);
    printf("      ");
    }
}

// Bildschirm Daten Anzeige
void ShowInfo() {
    int s;
    // Spalte der Anzeige
    s = 72;
    // Sternzeit
    SetCursorxy(s,2);
    printf("%.1f",stardate);
    // Restliche Spielzeit
    SetCursorxy(s,3);
    printf("%.1f",gametime);
    // Alarmstatus Raumschiff
    SetCursorxy(s,4);
    printf("%s",condition);
    // Aktueller Quadrant
    SetCursorxy(s,5);
    printf("%d - %d",qx,qy);
    // Aktueller Sektor
    SetCursorxy(s,6);
    printf("%d - %d",sx,sy);
    // Anzahl verfügbarer Torpedos
    SetCursorxy(s,7);
    printf("%d",torp);
    // Verfügbare Energie
    SetCursorxy(s,8);
    printf("%.0f",energy);
    // Aktuelle Energie auf Schutzschild
    SetCursorxy(s,9);
    printf("%d",shield);
    // Restlche Anzahl Klingonen
    SetCursorxy(s,10);
    printf("%d",klcount);

    // Systembericht
    SetCursorxy(s,14);
    printf("%d %%",damwarp);
    SetCursorxy(s,15);
    printf("%d %%",damlrs);
    SetCursorxy(s,16);
    printf("%d %%",damimp);
    SetCursorxy(s,17);
    printf("%d %%",damshield);
    SetCursorxy(s,18);
    printf("%d %%",damphaser);
    SetCursorxy(s,19);
    printf("%d %%",damtorp);
    SetCursorxy(s,20);
    printf("%d %%",damcomp);


}



// Anzeige Bildschirmlayout ohne Daten
void ShowScreen() {
    // Bildschirm löschen
    gp_clearscreen();
    gp_cursor_off();
    //Long-Range-Sensor 
    WriteScreenxy(35,0, "L-R Sensor");
    DrawLine(138,240,336,240);
    // Gitter
    // Vertikal
    DrawLine(186,240,186,180);
    DrawLine(222,240,222,180);
    DrawLine(258,240,258,180);
    DrawLine(294,240,294,180);
    // Horizontal
    DrawLine(186,220,294,220);
    DrawLine(186,200,294,200);
    DrawLine(186,180,294,180);

    // Schmucklinien LRS schräg
    DrawLine(138,240,186,180);
    DrawLine(336,240,294,180);
    // LRS vertikal kurz links
    DrawLine(180,240,180,200);
    DrawLine(174,240,174,210);
    DrawLine(168,240,168,220);
    DrawLine(162,240,162,230);
    DrawLine(156,240,156,235);
    DrawLine(150,240,150,238);
    // LRS vertikal kurz rechts
    DrawLine(300,240,300,200);
    DrawLine(306,240,306,210);
    DrawLine(312,240,312,220);
    DrawLine(318,240,318,230);
    DrawLine(324,240,324,235);
    DrawLine(330,240,330,238);

    // Short-Range-Sensor
    WriteScreenxy(35,8, "S-R Sensor");
    DrawLine(138,160,336,160);
    DrawLine(138,40,336,40);
    DrawLine(138,160,138,40);
    DrawLine(336,160,336,40);

    WriteScreenxy(25,10, "-0--1--2--3--4--5--6--7--8--9-");
    WriteScreenxy(24,11, "9");
    WriteScreenxy(24,12, "8");
    WriteScreenxy(24,13, "7");
    WriteScreenxy(24,14, "6");
    WriteScreenxy(24,15, "5");
    WriteScreenxy(24,16, "4");
    WriteScreenxy(24,17, "3");
    WriteScreenxy(24,18, "2");
    WriteScreenxy(24,19, "1");
    WriteScreenxy(24,20, "0");
    // Info
    WriteScreenxy(65,0, "Info");
    DrawLine(348,240,468,240);
    WriteScreenxy(58,2, "Sternzeit");
    WriteScreenxy(58,3, "Restzeit");
    WriteScreenxy(58,4, "Alarmstatus");
    WriteScreenxy(58,5, "Quadrant");
    WriteScreenxy(58,6, "Sektor");
    WriteScreenxy(58,7, "Ph-Torpedos");
    WriteScreenxy(58,8, "Energie");
    WriteScreenxy(58,9, "Schilde");
    WriteScreenxy(58,10, "Klingonen");
    // Systembericht
    WriteScreenxy(61,12, "Systembericht");
    DrawLine(348,120,468,120);
    WriteScreenxy(58,14, "Warp Antrieb");        
    WriteScreenxy(58,15, "L-R Sensor");
    WriteScreenxy(58,16, "Impulsantrieb");
    WriteScreenxy(58,17, "Schilde");
    WriteScreenxy(58,18, "Phaser");            
    WriteScreenxy(58,19, "Torpedos");
    WriteScreenxy(58,20, "Computer");
    // Kommandos
    WriteScreenxy(7,0, "Kommandos");
    DrawLine(12,240,120,240);

    WriteScreenxy(2,2, "(W)arpantrieb");
    WriteScreenxy(2,3, "(P)haser");
    WriteScreenxy(2,4, "(T)orpedos");
    WriteScreenxy(2,5, "(R)eparatur");
    WriteScreenxy(2,6, "(E)xkurs Planet");
    WriteScreenxy(2,7, "(C)omputer");
    WriteScreenxy(2,8, "(Q)uit");
    // Hilfe
    WriteScreenxy(9,12, "Hilfe");
    DrawLine(12,120,120,120);

    // EIngabe und Nachrichten
    WriteScreenxy(2,22, "Kommando:");
    WriteScreenxy(2,23, "Nachricht:");

}
