/*
 *	GDP.H
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

/* Information zur Farbe für GDP im FPGA*/
/*  #define BLACK       0u
    #define WHITE       1u
    #define YELLOW      2u
    #define GREEN       3u
    #define RED         4u
    #define BLUE        5u
    #define MAGENTA     6u
    #define CYAN        7u
    #define GRAY        8u
    #define DARK        8u	// can be or'ed to colors to make them darker 
*/

// Farbe wird in dieser Spielversion nicht verwendet

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <ndrcomp/target.h>
#include <ndrcomp/sysclock.h>
#include "../../nkc_common/nkc/nkc.h"


// Definitionen für GDP 
#define X_RES 512
#define Y_RES 256

#define SetCurrentColor SetCurrentFgColor
//#define BGCOLOR (BLACK|DARK)
#define BGCOLOR (BLACK)


// Umrechnung Grafikauflösung in Zeilen und Spalten 
// Spalten: 512 / 6 = 80 (0...79), 
// Zeilen(32): 256 / 8 = 32 (0...31)
// Zeilen(25): 256 / 10 = 25 (0...24)
// Ursprung Zeile / Spalte unten links
#define CCNV_X(X) (((uint16_t)X)*6u)
#define CCNV_Y(Y) (((uint16_t)Y)*10u-4)


static inline __attribute__((always_inline)) void gdp_ready(void) {
   while(!(GDP.cmd & 0x04u)) {};
}

static inline __attribute__((always_inline)) void SetCurrentFgColor(uint8_t fg) {
   //fg_color = fg;
    GDP_Col.fg=fg;
}

static inline __attribute__((always_inline)) void SetCurrentBgColor(uint8_t bg) {
   //bg_color = bg;
   GDP_Col.bg=bg;
}

// Schreibt auf den zwei ersten Bildschirmseiten
// Wird benötigt, dass blikender Cursor funktioniert
// gp_writexy schreibt in Bildschirmkoordinaten (512x256 Pixel)
static inline __attribute__((always_inline)) void WriteScreenxy(uint16_t x, uint16_t y,const char* const p_str)
{
   // Koordinaten umrechnen für Texteingabe mit Format Zeile 0 - 23 von Ursprung oben links
   y = abs(y-24)+1;
   for(uint8_t page=0u;page<2u; page++) {
      // Text schreiben auf Seite 0 und 1 (wegen blinkendem Cursor)
      gp_newpage(page,0u);
      gp_writexy(CCNV_X(x),CCNV_Y(y),0x11, p_str);
   }   
}

// Setzen des Bildschirmcursors
// gp_setcurxy setzt Cursor in Textzeilen
static inline __attribute__((always_inline)) void SetCursorxy(uint8_t x, uint8_t y)
{
   gp_setcurxy(x,y);
}

// Zeichnet Linie für einfache Grafik
static inline __attribute__((always_inline)) void DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2)
{
   for(uint8_t page=0u;page<2u; page++) {
      gp_newpage(page,0u);
      gp_moveto(x1,y1);
      gp_drawto(x2,y2);
   }
}
