/*
 * HELP.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */


// Hilfeanzeige für CTREK

void ClearHilfe() {
    int x,y;
    // Hilfebereich löschen Zeilen 11 bis 21
    for (y=14;y<22;y++) {
        for (x=0;x<22;x++) {
            WriteScreenxy(x,y, " ");
        }
    }
    ClearCommandLine();
}

// Hilfe für Spiel Kommandos 
void ShowHilfe(int index) {
    // Indexliste
    // 0 = leer
    // 1 = Warpantrieb -> Warpfaktor, Distanz in Quadranten und Richtung
    // 2 = Impulsantrieb -> Pfeiltasten für Einzelschritt im Sektor
    // 3 = Phaser -> Einzelschuss mit 200 Energieeinheiten
    // 4 = Torpedos -> Abschusswinkel für Torpedo, Einzelschuss
    // 5 = Schilde -> Energie auf die Schilde
    // 6 = Reparatur -> Anzahl Reparaturtage
    // 7 = Planetenexkurs -> Dilithiumsuche Dauer ra * 10 * TIMEUNIT
    // 8 = Computer -> 1 - Suche Basis,  2 - bekanntes Universum, 3 - Nothilfe
    // Hilfeanzeige links unten
    int x,y;
    x = 2;
    y = 14;
    ClearHilfe();
    switch(index) {
        case 0: // Allgmeine Hilfe
                WriteScreenxy(x,y, "Bedienung");
                WriteScreenxy(x,y+1, "-> Kommandos");
                WriteScreenxy(x,y+2, " -> Taste WPTRECQ");
                WriteScreenxy(x,y+3, "-> Impuls");
                WriteScreenxy(x,y+4, " -> Pfeilasten");
                WriteScreenxy(x,y+5, "-> Schilde");
                WriteScreenxy(x,y+6, " -> +/- Tasten");
                break;
        case 1: // Warpantrieb
                WriteScreenxy(x,y, "Warpantrieb");
                WriteScreenxy(x,y+1, "-> Warpfaktor");
                WriteScreenxy(x,y+2, "-> Distanz");
                WriteScreenxy(x,y+3, "-> Richtung");
                WriteScreenxy(x,y+4, "(ESC = Abbruch)");
                break;
        case 3: // Phaser
                WriteScreenxy(x,y, "Phaser");
                WriteScreenxy(x,y+1, "naechstes Ziel");
                WriteScreenxy(x,y+2, " 200 Energie");
                WriteScreenxy(x,y+3, "   je Schuss");
                break;
        case 4: //Torpedos
                WriteScreenxy(x,y, "Torpedo");
                WriteScreenxy(x,y+1, "-> Richtung");
                WriteScreenxy(x,y+2, " -> 0 - 360");
                WriteScreenxy(x,y+3, "(0 = rechts)");
                WriteScreenxy(x,y+4, "(ESC = Abbruch)");
                break;
        case 6: //Reparatur
                WriteScreenxy(x,y, "Reparatur");
                WriteScreenxy(x,y+1, "-> Anz. Sterntage");
                WriteScreenxy(x,y+2, " -> 1 - Max(Spiel)");
                WriteScreenxy(x,y+3, "(ESC = Abbruch)");
                break;
        case 7: //Planetenexkurs
                WriteScreenxy(x,y, "Planetenexkurs");
                WriteScreenxy(x,y+1, "Dilithiumsuche");
                WriteScreenxy(x,y+2, "Fund per Zufall");
                break;
        case 8: // Computer
                WriteScreenxy(x,y, "Computer");
                WriteScreenxy(x,y+1, "-> 1 = Suche Basis");
                WriteScreenxy(x,y+2, "-> 2 = Universum");
                WriteScreenxy(x,y+3, "-> 3 = Nothilfe");
                WriteScreenxy(x,y+4, "(ESC = Abbruch)");
                break;
        case 9: // Spiel beenden
                WriteScreenxy(x,y, "Quit");
                WriteScreenxy(x,y+1, "-> J = Ende");
                WriteScreenxy(x,y+2, "(Ret = Abbruch)");
                break;
    }

}
