/*
 * INIT.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

 // Initialisierungen CTREK


// Initialisierung für Sternenzeit, Position Quadrant und Sektor
// zu Spielbeginn
void InitGame() {
    srand((unsigned) _gettime());
    double ra;
    // Sternenzeit für Beginn berechnen
    stardate = (RandomOne()*20+20)*100;
    // Startquadrant und Sektor fuer Raumschiff berechnen
    ra = (double)rand() / RAND_MAX * 9.0 + 1;
    qx = (int) ra;
    ra = (double)rand() / RAND_MAX * 9.0 + 1;
    qy = (int) ra;
    ra = (double)rand() / RAND_MAX * 9.0 + 1;
    sx = (int) ra;
    ra = (double)rand() / RAND_MAX * 9.0 + 1;
    sy = (int) ra;


}

// Spieldaten im Universum berechnen und eintragen 
// in den Quadranten
void InitUniversum() {
    // Universum initialiseren
    int ix,iy;
    double ra;
    int kl, sb, st;
    int sum;
    // Quadranten löschen und initialiseren (0...10), ES ist leere Sektorposition
    for (iy = 0; iy <= 10; iy++) {
        for (ix = 0; ix <= 10; ix++) {
            Universum[ix][iy] = ES;
            KumUniversum[ix][iy] = ES;
        }
    }

    // Klingonen und Starbases zurücksetzen
    sumkl = 0;
    sumsb = 0;
    // Die Quadranten besetzen
    for (iy = 0; iy < 10; iy++) {
        for (ix = 0; ix < 10; ix++) {
            sum = 0;
            // Anzahl Klingonen
            kl = 0;
            ra = (double)rand() / RAND_MAX;
            if (ra > 0.80) kl = 1;
            if (ra > 0.92) kl = 2;
            if (ra > 0.98) kl = 3;
            sumkl += kl;
            // Anzahl Starbases
            sb = 0;
            ra = (double)rand() / RAND_MAX;
            if (ra > 0.95) sb = 1;
            sumsb += sb;
            // Sterne
            ra = (double)rand() / RAND_MAX;
            st = (int)(ra * 8 + 1);
            // Klingonen, Starbases und Sterne im Quadrant speichern
            sum = (kl*100) + (sb*10) + st;
            Universum[ix][iy] = sum;

            // Kumulativen Universum Monitor löschen
            KumUniversum[ix][iy] = 0;
        }    
    }
    klcount = sumkl;
    // Anhand der Anzahl der Klingonen die Spielzeit bestimmen
    // Standardspielzeit gametime = 30.0
    // Wenn mehr als 30 Klingonen gibt es für jeden 0.75 Tage dazu
    if (klcount > 30) {
        gametime += ((klcount - 30) * 0.75);
    }
    //gp_ci();

}



