/*
 *	MOVE.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

// Raumschiff bewegen mit Warp und Impulsantrieb

void MoveImpuls(int direction) {
    // Impulsantrieb beschädigt?
    if (damimp < MAXDAM) {
        WriteMessageLine("Impulsantrieb defekt! Taste...");
        // Return oder Taste für weiter
        gp_ci();
        ClearMessageLine();
        return;
    }

    // Einzelschrittbewegung mit Impulsantrieb im Sektor
    // direction 
    // 6 = nach rechts
    // 8 = nach oben
    // 2 = nach unten
    // 4 = nach links
    int tx, ty, gx, gy;
    gx = 0;
    gy = 0;
    int qwechsel;
    qwechsel = 0;
    // Energiebedarf prüfen und abrechnen, wenn möglich
    if (CalcEnergy(IMPULS, 1) == 0) return;
    // Zeitbedarf 1 Sektor Distanz * TIMEUNIT und von Spielzeit abrechnen
    if (CalcTime(1) == 0) return;
    // Reparatur der Systeme bei Bewegung
    CalcRepair(1);
    // Messageline löschen
    ClearMessageLine();
    tx = sx;
    ty = sy;
    if (direction == 6) tx++;
    if (direction == 8) ty++;
    if (direction == 2) ty--;
    if (direction == 4) tx--;

    // Grenzbehandlung an der Quadrantengrenze
    // Die Torusfunktion wird bei Impuls nicht angewendet,
    // seitliche Grenzen de Universum können nur mit Warp
    // überwunden werden (Torusberechnung in warpmove)
    if (tx < 0 || tx > 9 || ty < 0 || ty > 9) {
        // Quadrantenwechsel durchführen, Grenze erreicht
        if (qx > 0 && tx < 0) {
            //Linke Grenze
            qx--;
            gx = 9;
            gy = ty;
            qwechsel = 1;
        } else if (qx < 9 && tx > 9) {
            // Rechte Grenze
            qx++;
            gx = 0;
            gy = ty;
            qwechsel = 1;
        } else if (qy > 0 && ty < 0) {
            // Untere Grenze
            qy--;
            gy = 9;
            gx = tx;
            qwechsel = 1;
        } else if (qy < 9 && ty > 9) {
            // Obere Grenze
            qy++;
            gy = 0;
            gx = tx;
            qwechsel = 1;
        } else {
            WriteMessageLine("Aussengrenze!");
            return;
        } 

    } else {
            // Kollisionsprüfung, kein Quadrantenwechsel
        if (Sektor[tx][ty] > 0) {
            // Kollision mit anderem Objekt
            // Keine Aktion
            // Message ausgeben
            WriteMessageLine("Kollision!"); 
            return;
        }
    }
    // Neu Position ist ok
    if (qwechsel == 0) {
        // Raumschiff bleibt im aktuellen Quadranten
        Sektor[sx][sy] = ES;
        sx = tx;
        sy = ty;
        Sektor[sx][sy] = RS;
        // Ein Angriff der Klingonen erfolgt erst nach einer Bewegung mit Impulse im Quadranten
        KlingonAttack();    
    } else {
        // Raumschiff verlässt Quadranten
        sx = gx;
        sy = gy;
        FillSector();
        FillLRS();
        ShowLRS();
    }
    // ShortrangeSensor anzeigen mit Check Klingonen
    ShowSRS();
    // Ist Raumschiff gedockt an Basis oder im Orbit eine Planeten?
    CheckDocking();
    ClearInfo();
    ShowInfo();
    // KOmmandozeile löschen
    ClearCommandLine();
    // Zurück zur Kommandoebene
    return;
}





void MoveWarp(int distance, int angle) {
    // Distanz in WARP bezogen auf Quadranten (* 10 Sektoren)
    // Bewegung findet in 10 Quadranten x 10 Sektoren statt
    int tx = qx * 10 + sx;
    int ty = qy * 10 + sy;
    int dx = (distance * icos(angle));
    int dy = (distance * isin(angle));
    int rx = (dx + tx + WIDTH) % WIDTH;
    int ry = (dy + ty + HEIGHT) % HEIGHT;
    qx = rx / 10;
    qy = ry / 10;
    // Letzte Position merken
    psx = sx;
    psy = sy;
    // Neue Position ermitteln
    sx = rx % 10;
    sy = ry % 10;
    // Message ausgeben
    //SetCursorxy(15,23);  
    //printf("Fa: %d Ri: %d -> tx=%d,ty=%d: qx=%d,qy=%d,sx=%d,sy=%d",distance,angle,tx,ty,qx,qy,sx,sy); 

}


void Warp() {
    // Raumschiff mit Warp- oder Impulsantrieb bewegen
    // Parameter: faktor (WARPFAKTOR Default = 10)
    // Richtung: 0 - 360 Grad (0 = rechts, gegen den Uhrzeigersinn)
    // Distanz berechnet aus Faktor * Distanz

    // Warpantrieb beschädigt?
    if (damwarp < MAXDAM) {
        WriteMessageLine("Warpantrieb defekt! Taste...");
        // Return oder Taste für weiter
        gp_ci();
        ClearMessageLine();
        return;
    }

    int warpfaktor;
    warpfaktor = 0;
    int distanz;
    distanz = 0;
    int winkel;
    winkel = 0;
    int tx, ty;
    tx = qx;
    ty = qy;

    ClearCommandLine();
    ClearMessageLine();
    warpfaktor = GetParamAtXY(12,22,1,8,1, "Warp -> Warpfaktor (1-8)?");
    if (warpfaktor == -1) {
        ClearCommandLine();
        return;
    }
    ClearCommandLine();
    distanz = GetParamAtXY(12,22,1,8,1, "Warp -> Distanz wieviele Quadranten (1-8)?");
    if (distanz == -1) {
        ClearCommandLine();
        return;
    }
    // Distanz in Quadranten = Quadranten mal 10 für Sektoren in MoveWarp;
    distanz *= 10;
    ClearCommandLine();
    winkel = GetParamAtXY(12,22,0,360,3, "Richtung (0 - 360)?");
    // Energiebedarf und Zeitbedarf berechnen aus Distanz und Warpfaktor
    // Energiebeadrfs steigt mit Warpfaktor
    // Zeitbedarf sinkt mit Warpfaktor
    // Energiebedarf prüfen
    if (CalcEnergy(WARP, (distanz * warpfaktor)) == 0) return;
    // Distanz * TIMEUNIT (0.1 Sternentage) von Gametime abrechnen, wenn es reicht
    if (CalcTime((distanz / warpfaktor)) == 0) return;

    // Bei Warp werden die Schilde deaktiviert
    if (shield > 0) {
        energy += shield;
        if (energy > MAXENERGY) energy = MAXENERGY;
        shield = 0;
        WriteMessageLine("WARP: Schilde wurden deaktiviert!"); 
    }

    // Neue Position berechnen
    MoveWarp(distanz,winkel);

    // Prüfung, ob Sektor verlassen wurde
    if ((qx != tx) || (qy != ty)) {
        // Anderer Quadrant, Sektor neu füllen, LongRangeSensor neu berechnen
        FillSector();
        FillLRS();
    } else {
        // Raumschiff im selben Quadranten
        // Neu Position anfahren
        // Raumschiff platzieren
        if (Sektor[sx][sy] == 0) {
            // Neue Position setzen, wenn sx,sy frei (ES = 0)
            Sektor[sx][sy] = RS;
            // Alte Position löschen
            Sektor[psx][psy] = ES;
        } else {
            // Kollision mit anderem Objekt
            sx = psx;
            sy = psy;
            ClearMessageLine();
            // Message ausgeben
            SetCursorxy(15,23);  
            printf("Kollision! Neue Koordinaten (%d,%d)",sx,sy); 
        }
    }
    // ShortRangeSensor, LongRangeSensor und Dateninfo anzeigen
    ShowSRS();
    ShowLRS();
    ClearInfo();
    ShowInfo();
    // Kommandozeile leeren
    ClearCommandLine();
    // Zurück zur Kommandoebene
}