/*
 *	PHASER.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

 // Programme für PHASER

 // Phaser feuert auf Tastendruck mit <P> jeweils 200 Einheiten Energie
 // Jeder Schuss geht maximal 5 Sektoren weit
 // Jeder Schuss verliert 20% seiner Energie je Sektorentfernung
 // Es wird ein Schuss auf das nächste Ziel innerhalb der Reichweite im Sektor gefeuert
 // Schüsse über 5 Sektoren sind nicht möglich (Kein Ziel)

 // Klingonen haben zu Beginn 200 Einheiten Energie (Default)
 // Je näher man am Klingonen bei Feuern ist, desto höher
 // die Zerstörungskraft





 void Phaser() {


    // Ist Phaser in Betrieb
    if (damphaser < MAXDAM) {
        WriteMessageLine("Phaser defekt! Taste...");
        // Return oder Taste für weiter
        gp_ci();
        ClearMessageLine();
        return;
    }
    // Reicht Energie für Phaser
    if ((energy - MAXPHASER) <= 0) {
        // ZU wenig Energie für Phaser
        WriteMessageLine("Zu wenig Energie fuer Phaser! Taste...");
        // Return oder Taste für weiter
        gp_ci();
        ClearMessageLine();
        return;
    }

    // Gibt es Klingonen im Quadranten?
    if (klcountquad == 0) {   
        // Keine Klingonen im Quadranten
        WriteMessageLine("Keine Klingonen im Quadranten! Taste...");
        // Return oder Taste für weiter
        gp_ci();
        ClearMessageLine();
        return;
    }

     
    //  Nächstes Ziel wählen und Abstand bestimmen
    // Index des anzugreifenden Klingonen
    char message[79];
    int kindex, kabst;
    kindex = 0;
    kabst = 0;
    int abst;
    abst = 0;
    int phaser;
    int i;



    // Nächstmöglichen Klingonen suchen
    for (i=1;i <= klcountquad; i++) {
        // Wenn Klingone schon zerstört, nächsten nehmen
        if (klpos[i][3] == 0) continue;
        
       // Abstand zum Klingonen berechnen
        abst = abstand(sx,sy,klpos[i][0],klpos[i][1]);
        if (abst < MAXPHASERDIST) {
            // Klingone in Reichweite, merken
            kabst = abst;
            kindex = i;
            break;
        }
    }  
    // Wurde Klingone kindex in Reichweite kabst gefunden?
    if (kindex > 0) {
        // Klingone gefunden, Feuern!
        // Schussenergie nimmt mit Abstand ab
        // Schutz vor Division durch null
        if (kabst == 0) kabst = 1;
        phaser = MAXPHASER / kabst;
        // Schaden an Klingonen rechnen
        klpos[kindex][2] -= phaser;
        // Phaserenergie von Raumschiff Energie abziehen
        energy -= MAXPHASER;
        if (klpos[kindex][2] <= 0) {
            //Klingone zerstört, Energie < 0
            sprintf(message,"Nachricht: Klingone zestoert in Sektor (%d,%d). Taste...",klpos[kindex][0],klpos[kindex][1]);
            WriteScreenxy(2,23, message);
            gp_ci();
            ClearMessageLine();
            // Sektorfeld leeren
            Sektor[klpos[kindex][0]][klpos[kindex][1]] = ES;
            klpos[kindex][3] = 0; // Klingone zerstört
            klcount -= 1;
            klcountquad -= 1;
            if (Universum[qx][qy] > 100) {
                Universum[qx][qy] -= 100;
                KumUniversum[qx][qy] -= 100;
            }    
        } else {
            sprintf(message,"Nachricht: Treffer!! Klingone in Sektor (%d,%d) Restenergie %d. Taste...",klpos[kindex][0],klpos[kindex][1],klpos[kindex][2]);
            WriteScreenxy(2,23, message);
            gp_ci();
            ClearMessageLine();
        }
    } else {
        // Kein Klingone kindex = 0
        WriteScreenxy(2,23, "Nachricht: Kein Klingone in Reichweite! Taste...");
        gp_ci();
        ClearMessageLine();
    } 
    // ANzeige korrigieren
    ShowSRS();
    FillLRS();
    ShowLRS();
    ClearInfo();
    ShowInfo();
 }
