/*
 *	TOOLS.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

 // Hilfswerkzeuge wie Schilde, Reparatur, Docking, Exkurs


 void Repair() {
    // Raumschiff reparieren im Universum
    // Anzahl der Tage eingeben
    // 20 TIMEUNITS (0.05 Default) sind 1 Tag
    int tag;
    tag = 0;
    ClearCommandLine();
    ClearMessageLine();
    tag = GetParamAtXY(12,22,0,5,1, "Reparatur -> Anzahl Tage (0-5)?");
    // Abbruch bei ESC -1 oder 0 Tage = Return
    if (tag <= 0 ) return;
    // Tag umrechnen
    tag = tag / TIMEUNIT;
    CalcRepair(tag);
    if (CalcTime((tag)) == 0) return;
    ClearCommandLine();
    ClearInfo();
    ShowInfo();

    return;
 }

 void DiscoverPlanet() {
    // Wenn Raumschiff im Orbit, kann eine Exkusrsion zur 
    // Dilithiumsuche stattfinden
    double ra;
    int dilithium; 
    char message[50];
    ClearMessageLine();
    if (orbit == 0) {
        WriteMessageLine("Raumschiff nicht im Orbit eines Planeten!");
        return;
    }
    // Gefundenes Dilithium über Zufallszahl ermitteln
    ra = (double)rand() / RAND_MAX;
    if (ra > 0.60) {
        // Zeitbedarf ra * 10 * TIMEUNIT 
        if (CalcTime(ra*10) == 0) return;

        // Dilithium gefunden = 500 * ra
        dilithium = ra * 500;
        energy += dilithium;
        if (energy >= MAXENERGY) energy = MAXENERGY;
        sprintf(message,"%d Dilithium gefunden!",dilithium);
        WriteMessageLine(message);
    } else {
        // Kein Dilithium gefunden
        // Zeitbedarf ra * 10 * TIMEUNIT 
        if (CalcTime(ra*10) == 0) return;
        WriteMessageLine("Kein Dilithium gefunden.");
    }
    ShowInfo();
}


void CheckDocking() {
    // Prüfen ob Raumschiff neben Planeten oder Basis

    int i, j, xl, xr, yu, yo, docktyp;
    // Docktyp 1 = Basis, 2 = Planet, Default = 0
    docktyp = 0;
    // Orbit zurücksetzen
    orbit = 0;
    // Nachrichtenzeile zurücksetzen
    ClearMessageLine();
    // Koordinatengrenzen prüfen und docktyp feststellen, wenn vorhandne
    xl = -1;
    xr = 1;
    yu = -1;
    yo = 1;
    if (sx < 1) xl = 0;
    if (sx > 8) xr = 0;
    if (sy < 1) yu = 0;
    if (sy > 8) yo = 0;
    for (i = xl; i <= xr; i++) {
        for (j = yu;j <= yo; j++) {
            if (Sektor[sx+i][sy+j] == BS) docktyp = 1;
            if (Sektor[sx+i][sy+j] == PS) docktyp = 2;
        }
    }
    // Alarmstatus zurücksetzen
    strcpy(condition,CONDGREEN);
    if (docktyp == 1) {
        // An Raumbasis angedockt, Raumschiff geschützt
        strcpy(condition,CONDDOCK);
        energy = 3000;
        torp = 10;
        shield = 0;
        // Reparaturen durchführen
        damwarp = 100;
        damimp = 100;
        damlrs = 100;
        damshield = 100;
        damphaser = 100;
        damtorp = 100;
        damcomp = 100;
        // Message ausgeben
        WriteMessageLine("Raumschiff an Basis angedockt.");
    }
    if (docktyp == 2) {
        // Im Orbit um Planet, Raumschiff vor Klingonen versteckt
        strcpy(condition,CONDORBIT);
        orbit = 1;
        // Im Orbit keine Schilde
        energy += shield;
        if (energy >= MAXENERGY) energy = MAXENERGY;
        shield = 0;
        // Nachricht ausgeben
        WriteMessageLine("Raumschiff im Orbit. Exkurs kann gestartet werden.");
    }
    // Für Alarmstatus erst auf Klingonen prüfen
    // Klingonen vorhanden?, 100er Stelle im Universum abfragen
    if ((Universum[qx][qy] / 100) > 0) {
        // Klingonen im Sektor, Alarmstatus rot
        strcpy(condition,CONDRED);
        // Alarmstufe rot überschreibt alles
    }

}

 
void Shield(int value) {
    // Schildenergie steuern
    // value = 0 Schilde - 200 oder 0
    // value = 1 Schilde + 200 oder max 1000 (MAXSHIELD)
    int temp;
    if (value == 0) {
        // Schilde abbauen mit SHIELDINC = 200
        if (shield == 0) return;
        temp = shield - SHIELDINC;
        if (temp < 0) {
            // Restschildenergie übrig, Differen bestimmen
            temp += (temp * 2);
            // Differenz für Energy Gutschrift
            energy += temp;
            shield = 0;
        } else {
            shield -= SHIELDINC;
            energy += SHIELDINC;
        }   
    } else {
        // Reicht Energie zum Laden der Schirme?
        if (shield >= MAXSHIELD) return;
        if (SHIELDINC > energy) {
            WriteMessageLine("Energie reicht nicht zum Laden der Schirme!");
            return;
        }
        // Schilde laden mit SHIELDINC = 200
        if ((shield + SHIELDINC) > MAXSHIELD) {
            // Schilde bis MAXSHIELD aufladen
            energy -= (MAXSHIELD - SHIELDINC);
            shield = MAXSHIELD;
        } else {
            shield += SHIELDINC;
            energy -= SHIELDINC;
        }
    }

    ClearInfo();
    ShowInfo();
    return;
}
