/*
 *	TORPEDOS.C
 * Startrek für NKC 68k und TangNano
 * 
 * Ctrek ist dem Klassiker Startrek Spiel nachempfunden und aus
 * Originalquellen für Basic aus den 1980er Jahren nachempfunden
 */

 // Programme für TORPEDOS

 // Torpedos werden über den Abschusswinkel gefeuert
 // Es kann nur ein Torpedo gleichzeitig abgefeuert werden
 // 

 void Torpedo() {
    // Sind Torpedos verfügbar
    // SInd Torpedos betriebsbereit
    if (damtorp < MAXDAM) {
        WriteMessageLine("Torpedos defekt! Taste...");
        // Return oder Taste für weiter
        gp_ci();
        ClearMessageLine();
        return;
    }
    // Noch Torpedos im Magazin
    if (torp <= 0) {
        // Torpedos verschossen
        WriteMessageLine("Keine Torpedos mehr verfuegbar! Taste...");
        // Return oder Taste für weiter
        gp_ci();
        ClearMessageLine();
        return;
    }

    int winkel;
    winkel = 0;
    ClearCommandLine();
    winkel = GetParamAtXY(12,22,0,360,3, "Richtung (0 - 360)?");
    if (winkel == -1) {
        // Abbruch mit ESC
        ClearMessageLine();
        return;
    }
    // Kollisionsrechnung
   
    // Distanzangabe, maximal 10,damit verlässt der Torpedo beim Fehlschuss den Sektor garantiert
    int distanz = 10;
    // Objekt (Wert) bei Treffer, wird verglichen mit Objekten ES 0, RS 1, KS 2, BS 3, PS 4, SS 5 
    int obj = 0;
    // Schleifenvariable
    int i;
    // Startpunkt
    int x = sx;
    int y = sy;
    // Zielpunkt
    int x1 = sx + (distanz * icos(winkel));
    int y1 = sy + (distanz * isin(winkel));
    
    int dx = abs(x1 -sx);
    int dy = abs(y1 -sy);

    int sx_step = (sx < x1) ? 1 : -1;
    int sy_step = (sy < y1) ? 1 : -1;

    int err = dx -dy;

    // Schrittweise Prüfung
    //for (i=0;i<distanz;i++) {
    while (!(x == x1 && y == y1)) {
        int e2 = 2 * err;
        if (e2 > -dy) { err -= dy; x += sx_step; }
        if (e2 < dx) { err += dx; y += sy_step; }


        if (Sektor[x][y] > 0) {
            // Kollision bei x,y
            ClearMessageLine();
            SetCursorxy(15,23);
            // Hier Objekte auswerten
            obj = Sektor[x][y];
            switch(obj) {
                case KS: // Klingone getroffen, wird zerstört
                    printf("Klingone im Sektor bei (%d,%d) zerstoert. Taste ...",x,y);
                    gp_ci();
                    // Anzahl Klingonen im Quadranten abziehen 
                    Universum[qx][qy] -= 100;
                    // Sektorposition löschen
                    Sektor[x][y] = ES;
                    // Klingone aus klpos austragen
                    for (i=0; i<=3; i++) {
                        if (klpos[i][0] == x && klpos[i][1] == y) {
                            klpos[i][2] = 0; // Keine Energie mehr
                            klpos[i][3] = 0; // Klingone zerstoert
                        }
                    }
                    // Anzahl Klingonen dekrementieren
                    klcount -= 1; 
                    break;
                case BS: // Basis zerstört, Spielende
                    printf("Basis im Sektor bei (%d,%d) zerstoert. Schade! Taste ...",x,y);
                    gp_ci();
                    // Basis aus Quadrant abziehen
                    Universum[qx][qy] -= 10;
                    // Sektorposition löschen
                    Sektor[x][y] = ES;
                    // Anzahl Basen dekrementieren
                    sumsb -= 1;
                    break;
                case PS: // Planet getroffen. Geht nicht...
                    printf("Planet im Sektor bei (%d,%d) getroffen. Neue Feinde! Taste ...",x,y);
                    gp_ci();
                    break;
                case SS: // Planet getroffen. Geht nicht...
                    printf("Stern im Sektor bei (%d,%d) getroffen. Absorbiert. Taste ...",x,y);
                    gp_ci();
                    break;
            }
            // While verlassen
            break;
        }
        if (x < 0 || x >= 10 || y < 0 || y >= 10) {
            // Torpedo verlässt Sektor
            ClearMessageLine();
            SetCursorxy(15,23);  
            printf("Torpedo mit Winkel %d verlaesst Sektor bei (%d,%d)",winkel,x,y); 
            // WHile verlassen
            break;
        }

        
    }

    // Torpedo aus Bestand abziehen
    torp -= 1;
    // ShortRangeSensor, LongRangeSensor und Dateninfo anzeigen
    ShowSRS();
    FillLRS();
    ShowLRS();
    ClearInfo();
    ShowInfo();
    // Kommandozeile leeren
    ClearCommandLine();
    // Zurück zur Kommandoebene
    return;
 }
