********************************************************************************
*                          NKC - Light Pen Contol by sEn                       *
********************************************************************************
*                                                                              *
*       1) Anschluss an PIN 21 LPCK des EF9366                                 *
*       2) Verwendeter Fototransistor ist SFH 229 OSO (10 ns Reaktionszeit     *
*       3) Verwendeter Komparator ist LT 1016 (10 ns Schaltzeit)               *
*                                                                              *
********************************************************************************
*                                                                              *
*    Version 0.1 - Test der Schaltung und Response in XLP- und YLP-Register    *
*    Version 1.0 - Anlegen eines Controls, Ausloesen eines Controls            *
*                                                                              *
********************************************************************************

; Programmstart

start:
 bra lipe
rts


;* Konstanten

        CPU     EQU 1                       ;(68008)

        GDPBASE     EQU $FFFFFF70*CPU       ;GDP64 Basisadresse / Status / CMD
        GDPXLP      EQU GDPBASE+$0C         ;X Light Pen - 6 bit
                                            ;left justified, bit 0 = Status
        GDPYLP      EQU GDPBASE+$0D         ;Y Light Pen - 8 bit

        COMSCRW     EQU $C                  ;Bilschirm hell steuern
        COMLPIW     EQU $08                 ;Init. Light Pen m. weissem Bildsch.
        COMLPI      EQU $09                 ;Initialisierung Light Pen - nur


;* Variablen

  ;Control-Beschriftungen:
        c1:             dc.b 'con 1', 0
        c2:             dc.b 'con 2', 0

  ;Control Tabelle:
        contab:         df.w 100, $0000


;* Programm

lipe:

;* Button / Click Control 1 fr NKC Light Pen anlegen

 move #1, d6                     ;Nummer des Controls im Programm

;Control malen
 moveq #6, d0                    ;Ausgefuelltes Rechteck zeichnen
 moveq #100, d1                  ;X-Position
 moveq #100, d2                  ;Y-Position
 moveq #50, d3                   ;Positive Kantenlaenge X
 moveq #25, d4                   ;Positive Kantenlaenge Y
 moveq #!Grafik, d7              ;Control als Recheck malen
 trap #1

;Control in Tabelle eintragen
;Aufbau: W1 = X0, W2 = Y0, W3 = X1, W4 = Y1, W5 = Nr. Control
 lea contab (PC), A1             ;Control-Tabelle laden - nur beim 1. Control
 move d1, (A1)+                  ;X0
 move d2, (A1)+                  ;Y0
 add d1, d3
 move d3, (A1)+                  ;X1
 add d2, d4
 move d4, (A1)+                  ;Y1
 move d6, (A1)+                  ;Control Nr.

;Control beschriften
 moveq #!erapen, d7              ;GDP auf Loeschen
 trap #1
 moveq #23, d0                   ;Textausgabe
 lea c1 (PC), A0
 addq #5, d1                     ;Neue X-Position
 sub d2, d4                      ;Alte Kantenlaenge Y
 ror.w #1, d4                    ;Alte Kantenlaenge Y / 2
 add d4, d2                      ;Mitte des Controls
 subq #8, d2                     ;Neue Y-Position 4 Zeilen unter der Mitte
 moveq #$11, d3                  ;Schriftgroesse
 moveq #!grafik, d7
 trap #1
 moveq #!setpen, d7              ;GDP auf Schreiben
 trap #1

;* Button / Click Control 2 fr NKC Light Pen anlegen

 move #2, d6                     ;Nummer des Controls im Programm

;Control malen
 move #6, d0                     ;Ausgefuelltes Rechteck zeichnen
 move #175, d1                   ;X-Position
 move #100, d2                   ;Y-Position
 move #50, d3                    ;Positive Kantenlaenge X
 move #25, d4                    ;Positive Kantenlaenge Y
 moveq #!Grafik, d7              ;Control als Recheck malen
 trap #1

;Control in Tabelle eintragen
;Aufbau: W1 = X0, W2 = Y0, W3 = X1, W4 = Y1, W5 = Nr. Control
 move d1, (A1)+                  ;X0
 move d2, (A1)+                  ;Y0
 add d1, d3
 move d3, (A1)+                  ;X1
 add d2, d4
 move d4, (A1)+                  ;Y1
 move d6, (A1)+                  ;Control Nr.

;Control beschriften
 moveq #!erapen, d7              ;GDP auf Loeschen
 trap #1
 moveq #23, d0                   ;Textausgabe
 lea c2 (PC), A0
 addq #5, d1                     ;Neue X-Position
 sub d2, d4                      ;Alte Kantenlaenge Y
 ror.w #1, d4                    ;Alte Kantenlaenge Y / 2
 add d4, d2                      ;Mitte des Controls
 subq #8, d2                     ;Neue Y-Position 4 Zeilen unter der Mitte
 moveq #$11, d3                  ;Schriftgroesse
 moveq #!grafik, d7
 trap #1
 moveq #!setpen, d7              ;GDP auf Schreiben
 trap #1

;* Position des Light Pens ermitteln.

lppos:
 clr d1                                 ;X/Y Position fr Ausgabe initialisieren
 clr d2
 move.b #comlpi, d0                     ;Initialisierung Light Pen
 moveq #!cmd, d7
 trap #1
 move.b gdpxlp, d1                      ;X-Position Light Pen und Status
 btst.b #0, d1                          ;Light Pen Zyklus zuende?
 beq.s tast                             ;Wenn nicht, erneut ermitteln ...
 subq #1, d1                            ;und Tastatur abfragen
 rol.w #1, d1                           ;X-Komponente auf 0-511 umrechnen
 sub #56, d1                            ;Laufzeitkorrektur zwischen Stift
                                        ;und Anzeige (bei mir)
 move.b gdpylp, d2                      ;Y-Position Light Pen
 rol.w #1, d2                           ;Y-Komponente auf 0-511 umrechnen,
                                        ;weil Grafik-Befehl bei Y so arbeitet!

;* Abfrage der X/Y-Position des Light Pens und Zuordnung des Controls
;* Liefert die Control Nr. in d0.w oder aber $0000, wenn nicht gefunden.
;* Uebergeben werden XLP als d1.w und YLP als d2.w

chkcon:
 clr d0                          ;Ausgaberegister intialisieren
 lea contab, A0                  ;Control-Tabelle laden

 scon:
  move (A0)+, d3                  ;X0
  move (A0)+, d4                  ;Y0
  move (A0)+, d5                  ;X1
  move (A0)+, d6                  ;Y1
  move (A0)+, d0                  ;Control Nr.

  cmp #$0000, d0                  ;Tabellenende - k e i n  valides Control
  beq.s endcon

  cmp d3, d1                      ;Check XLP gegen X0
  ble.s scon                      ;Wenn XLP kleiner als X0, dann naechstes Contr
  cmp d5, d1                      ;Check XLP gegen X1
  bgt.s scon                      ;Wenn XLP groesser als X1, dann naechstes Cont
  cmp d4, d2                      ;Check YLP gegen Y0
  ble.s scon                      ;Wenn YLP kleiner als Y0, dann naechstes Contr
  cmp d6, d2                      ;Check YLP gegen X1
  bgt.s scon                      ;Wenn YLP groesser als X1, dann naechstes Cont
endcon:                         ;Passendes Control gefunden oder Tabellenende!

;* Auswertung der Contol Nr. in d0.w

 cmp #1, d0                     ;Control 1
 beq.s conact1
 cmp #2, d0                     ;Control 2
 beq.s conact2
 bra lppos                      ;k e i n  bekanntes Control
 conact1:                       ;Aktion Control 1
  moveq #!setpen, d7
  trap #1
  moveq #7, d0                  ;Kreis zeichnen
  move #255, d1
  move #300, d2
  move #75, d3
  moveq#!Grafik, d7
  trap #1
 bra lppos
 conact2:                       ;Aktion Control 2
  moveq #!erapen, d7
  trap #1
  moveq #7, d0                  ;Kreis loeschen
  move #255, d1
  move #300, d2
  move #75, d3
  moveq#!Grafik, d7
  trap #1
 bra lppos

rts

;* Tastaturabfrage

tast:
 moveq #!csts, d7
 trap #1
 beq lppos
 moveq #!ci, d7
 trap #1
 cmp.b #'e', d0                         ;Programmende
 bne lppos
rts

end.



