********************************************************************************
*                      NKC - Light Pen - Malprogramm by sEn                    *
********************************************************************************
*                                                                              *
*       1) Anschluss an PIN 21 LPCK des EF9366                                 *
*       2) Verwendeter Fototransistor ist SFH 229 OSO (10 ns Schaltzeit)       *
*       3) Verwendeter Komparator ist LT 1016 (10 ns Schaltzeit)               *
*                                                                              *
********************************************************************************
*                                                                              *
*    Version 0.1 - Test der Schaltung und Response in XLP- und YLP-Register    *
*    Version 1.0 - Malen auf dem Bildschirm, Positionieren und Lschen         *
*                                                                              *
********************************************************************************

; Programmstart

start:
 bra lipe
rts


;* Konstanten

        CPU     EQU 1                       ;(68008)

        GDPBASE     EQU $FFFFFF70*CPU       ;GDP64 Basisadresse / Status / CMD
        GDPXLP      EQU GDPBASE+$0C         ;X Light Pen - 6 bit
                                            ;left justified, bit 0 = Status
        GDPYLP      EQU GDPBASE+$0D         ;Y Light Pen - 8 bit

        COMSCRW     EQU $C                  ;Bilschirm hell steuern
        COMLPIW     EQU $08                 ;Init. Light Pen m. weissem Bildsch.
        COMLPI      EQU $09                 ;Initialisierung Light Pen - nur


;* Programm

;* Vorbereitung fuer den Light Pen:
;* Der Schreibstigt wird gesenkt und der Bildschirm hell gesteuert.
;* Der Schreibstift wird nun gehoben, da die helle Flche fr die Funktion des
;* Light Pen benoetigt wird und man darauf nur loeschend zeichnen kann.

lipe:
 moveq #!setpen, d7                     ;Schreibstift auf "Schreiben"
 trap #1
 move.b #comscrw, d0                    ;Bildschirm hell steuern
 moveq #!cmd, d7
 trap #1
 moveq #!erapen, d7                     ;Schreibstift auf "lschen"
 trap #1

;* Erste Position des Light Pens ermitteln, von der aus dann gezeichnet wird.

initpos:
 clr d1                                 ;Initialisierung X- und Y-Komponente
 clr d2                                 ;zum Zeichnen
 move.b #comlpi, d0                     ;Initialisierung Light Pen
 moveq #!cmd, d7
 trap #1
 move.b gdpxlp, d1                      ;X-Position Light Pen und Status
 btst.b #0, d1                          ;Light Pen Zyklus zuende?
 beq.s initpos                          ;Wenn nein, dann nochmal pruefen
 rol.w #1, d1                           ;X-Komponente auf 0-511 umrechnen
 sub #56, d1                            ;Laufzeitkorrektur zwischen Stift
                                        ;und Anzeige (bei mir)
 move.b gdpylp, d2                      ;Y-Position Light Pen
 moveq #!moveto, d7                     ;Position Schreibsift neu setzen
 trap #1

;* Ab hier malen ...

schreiben:
 clr d1                                 ;Initialisierung X- und Y-Komponente
 clr d2                                 ;zum Zeichnen
 move.b #comlpi, d0                     ;Initialisierung Light Pen
 moveq #!cmd, d7
 trap #1
 move.b gdpxlp, d1                      ;X-Position Light Pen und Status
 btst.b #0, d1                          ;Light Pen Zyklus zuende?
 beq.s tast                             ;Nein, dann Tastaturabfrage
 rol.w #1, d1                           ;X-Komponente auf 0-511 umrechnen
 sub #56, d1                            ;Laufzeitkorrektur zwischen Stift
                                        ;und Anzeige (bei mir)
 move.b gdpylp, d2                      ;Y-Position Light Pen
 moveq #!drawto, d7                     ;Dunkle Linie malen
 trap #1
 bra.s schreiben

;* Tastaturabfrage

tast:
 moveq #!csts, d7                       ;Wenn keine Taste gedrueckt, weiter mit
 trap #1                                ;'schreiben'
 beq.s schreiben
 moveq #!ci, d7                         ;Wenn Taste gedrueckt, dann ...
 trap #1
 cmp.b #'n', d0
 beq initpos                            ;Neue Position ohne Schreiben
 cmp.b #'c', d0                         ;Bildschirm lschen
 beq lipe
 cmp.b #'e', d0                         ;Programmende
 bne.s schreiben

rts

end.
