********************************************************************************
*                              NKC - Light Pen by sEn                          *
********************************************************************************
*                                                                              *
*       1) Anschluss an PIN 21 LPCK des EF9366                                 *
*       2) Verwendeter Fototransistor ist SFH 229 OSO (10 ns Reaktionszeit     *
*       3) Verwendeter Komparator ist LT 1016 (10 ns Schaltzeit)               *
*                                                                              *
********************************************************************************
*                                                                              *
*    Version 0.1 - Test der Schaltung und Response in XLP- und YLP-Register    *
*    Version 1.0 - Dezimale Anzeige von X- und Y-Position des Light Pens       *
*                                                                              *
********************************************************************************

; Programmstart

start:
 bra lipe
rts


;* Konstanten

        CPU     EQU 1                       ;(68008)

        GDPBASE     EQU $FFFFFF70*CPU       ;GDP64 Basisadresse / Status / CMD
        GDPXLP      EQU GDPBASE+$0C         ;X Light Pen - 6 bit
                                            ;left justified, bit 0 = Status
        GDPYLP      EQU GDPBASE+$0D         ;Y Light Pen - 8 bit

        COMSCRW     EQU $C                  ;Bilschirm hell steuern
        COMLPIW     EQU $08                 ;Init. Light Pen m. weissem Bildsch.
        COMLPI      EQU $09                 ;Initialisierung Light Pen - nur

;* Variablen

        buffer:     ds.b 10
        lbuff:      dc.b '                 ', 0   ; SPACES

;* Info zum Programm

;* Zu den Koordinatenwerten aus dem XLP- und dem YLP-Register:

;* Das YLP-Register zeigt in seinen 8 Bit die Werte von Zeile 0 bis 255 an.
;* Diesen Wert kann man direkt fr MOVETO oder DRAWTO verwenden.
;* Das XLP-Register zeigt in den linken 6 Bit einen Wert von 0-63.

;* Dies entspricht 64 moeglichen Speicherzyklen mit jeweils 8 Bit.
;* Der GDP waehlt 1 Punkt immer mit einem Speicherzyklus und innerhalb der 8 Bit
;* mit den Signalen MSL0, MSL1 und MSL2 aus.
;* Bit 1 ist fix '0' gesetzt. Bit 0 wird als Light Pen Zyklus Status genutzt.
;* Laesst man die 6 Bit der Positionsinformation da stehe, wo sie sind, koennen
;* sie Werte von 1-253 annehmen.
;* Beruecksichtigt man das Status-Bit 0 nicht, erhaelt man durch ein links
;* Rotieren um 1 Werte von 2-506, die jetzt fuer MOVETO und DRAWTO eingesetzt
;* werden koennen.
;* Hier muss jetzt noch die Laufzeit von Light Pen-Signal bis zur Bildschirmaus-
;* gabe korrigiert werden. Damit wird auch um den Wert des Status-Bits korri-
;* giert.
;* Fuer die Y-Komponente ist keine Korrektur notwendig.

;* Achtung: Bei meinem Aufbau habe ich festgestellt, dass am rechten Rand nach
;*          dem MaximalwWert '11111100' fuer XLP wieder ein kleinerer Wert ent-
;*          steht. Man muss also die hell gesteuerte Bildschirmflaeche am
;*          rechten Rand beschneiden.


;* Programm

;* Vorbereitung fuer den Light Pen:
;* Der Schreibstigt wird gesenkt und der Bildschirm hell gesteuert.
;* Der Schreibstift wird nun gehoben, da die helle Flche fr die Funktion des
;* Light Pen benoetigt wird und man darauf nur loeschend zeichnen kann.

lipe:
 moveq #!setpen, d7                     ;Schreibstift auf "Schreiben"
 trap #1
 move.b #comscrw, d0                    ;Bildschirm hell steuern
 moveq #!cmd, d7
 trap #1
 moveq #!erapen, d7                     ;Schreibstift auf "Lschen"
 trap #1
 moveq #40, d1                          ;Dunkle Zone fuer Koordinatenanzeige
 move #190, d2
 move #230, d3
 moveq #50, d4
 moveq #6, d0
 moveq #!Grafik, d7
 trap #1

;* Position des Light Pens ermitteln.

initpos:
 clr d3                                 ;X/Y Position fr Ausgabe initialisieren
 clr d4
 move.b #comlpi, d0                     ;Initialisierung Light Pen
 moveq #!cmd, d7
 trap #1
 move.b gdpxlp, d3                      ;X-Position Light Pen und Status
 btst.b #0, d3                          ;Light Pen Zyklus zuende?
 beq.s initpos                          ;Wenn nicht, erneut ermitteln ...
 subq #1, d3
 rol.w #1, d3                           ;X-Komponente auf 0-511 umrechnen
 sub #56, d3                            ;Laufzeitkorrektur zwischen Stift
                                        ;und Anzeige (bei mir)
 move.b gdpylp, d4                      ;Y-Position Light Pen

;* Koordinatenanzeige X/Y zum Test des Light Pen

  lea lbuff, A0                         ;Anzeige loeschen
  moveq #$22, d0
  moveq #50, d1
  moveq # 100, d2
  moveq #!write, d7
  trap #1
  move d3, d0                           ;Dezimalausgabe X-Position
  lea buffer, A0
  move.b #'X', (A0)+
  move.b #':', (A0)+
  move.b # ' ', (A0)+
  moveq #!print4d, d7
  trap #1
  lea buffer, A0
  move #$22, d0
  move #50, d1
  move #100, d2
  moveq #!write, d7
  trap #1
  move.b d4, d0                         ;Dezimalausgabe Y-Position
  lea buffer, A0
  move.b #'Y', (A0)+
  move.b #':', (A0)+
  move.b # ' ', (A0)+
  moveq #!print4d, d7
  trap #1
  lea buffer, A0
  move #$22, d0
  move #180, d1
  move #100, d2
  moveq #!write, d7
  trap #1

;* Tastaturabfrage

tast:
 moveq #!csts, d7
 trap #1
 beq initpos
 moveq #!ci, d7
 trap #1
 cmp.b #'e', d0                         ;Programmende
 bne initpos

rts

end.
