                     ; ***************************************************************
;
;					 	Displaytest_1.asm
;
;    			 PS 2 Keyboard auf LCD Display Vers. 1.2
;
; Num Look senden zustzlich E0 11 E0 = Shift nicht implementiert
; ***************************************************************


.include "2313def.inc"

; Namen definieren, z.B. fr Prozessor-Register
; Achtung "Immediate"-Befehle sind nur bei r16 - r31 mglich!
; und r26-r31 sind Adressregisterpaare xyz
.def	temp	 = r16		; Register fr alles mgliche
.def	data	 = r17		; Register fr Datensendung 
.def	txt 	 = r18		; Register fr Textausgabe
.def	counter1 = r19		; Register fr Zhler1 (Zeitverzgerung) 
.def	counter2 = r20		; Register fr Zhler2 (Zeitverzgerung)
.def	counter3 = r21		; Register fr Zhler3 (Zeitverzgerung)
.def	LCDYX    = r22		; Pos X LCD
.def    LastKey  = r23
.def    CharCoun = r24
.def	LEDTast  = r25
.def	status	 =  r0		; STATUS Register
.def    Alt      = r2
.def    Shift	 = r3		; Merker Shift
.def    Strg     = r4		; Merker Strg
.def    Bre      = r5		; Merker Bre ak Code
.def    E0       = r6		; Merker E0
.def    E0Bre	 = r7       ; Merker Bre ak E0
	
; ************************ Quell-Code ************************

; *** Interrupt-Table ***

	rjmp	RESET		; Reset-Vektor, muss vorhanden sein
						;(Einsprungadresse nach Power-Up)
	rjmp TastInt            ;External Interrupt 0 Vector Adress
	RETI ; INT1addr=$002	;External Interrupt 1 Vector Adress
	RETI ; ICP1addr=$003	;Input Capture1 Interrupt Vector Address
	RETI ; OC1Aaddr=$004	;Output Compare1A Interrupt Vector Address
	RETI ; OVF1addr=$005	;Overflow1 Interrupt Vector Address
	RETI ; OVF0addr=$006	;Overflow0 Interrupt Vector Address
	RETI ; SPIaddr =$007	;SPI Interrupt Vector Address
	RETI ; URXCaddr=$008	;UART Receive Complete Interrupt Vector Address
	RETI ; UDREaddr=$009	;UART Data Register Empty Interrupt Vector Address
	RETI ; UTXCaddr=$00A	;UART Transmit Complete Interrupt Vector Address
	RETI ; ADCCaddr=$00B	;ADC Interrupt Vector Address
	RETI ; ERDYaddr=$00C	;EEPROM Interrupt Vector Address
	RETI ; ACIaddr =$008	;Analog Comparator Interrupt Vector Address

				;1234567890123456

; *** Programm-Start ***
RESET:
init:
	ldi temp, RAMEND    	;Stackpointer initialisieren
	out SPL, temp
	ser	temp		; temp <- 0xFF (temp auf 1111 1111)
 	out	DDRB,temp	; Port B -> Alle Pins Output
	out DDRD, temp  ; Port D -> Alle Pins Output
	clr	temp		; temp <- 0x00 (temp auf 0000 0000)
	out	PORTB,temp	; Alle Pins PORTB -> Alle Pins Low
	ldi temp,0b00000110
	out PORTD,temp	; Alle Pins PORTD -> Alle Pins Low
	ldi temp,0b11111001
	out DDRD, temp
	ldi temp,0b00000110
	out PORTD,temp	; Alle Pins PORTD -> Alle Pins Low
	ldi temp, 0b00000010		; INT0 konfigurieren
	out MCUCR, temp
	ldi temp, 0b11000000		; INT0 und INT1 aktivieren
	out GIMSK, temp

	ldi data,0xff			; Reset senden an Tastatur
	rcall TastSend
	out portb,temp
	clr counter1	; Zhler1 zurcksetzen
	clr counter2	; Zhler2 zurcksetzen
	clr counter3	; Zhler3 zurcksetzen
	clr	Shift
	clr Strg
    clr Alt
    clr E0
	clr E0Bre
    clr Bre
	clr LastKey
	clr LEDTast
	ldi LCDYX,0b10000000    ;LCD YX DD Speicher Pos 0 max. 15
	rcall init_lcd			;Display initialisieren
	rcall clear_lcd			;Display lschen
	ldi data,0b10000000     ; Cursor 1 1
	rcall data2lcd	     	;Befehl bertragen
    ldi data,0xED			; ED fr Lampen Steuerung
	rcall TastSend 
	clr Data
	sbr Data,1<<0			; Bit 2 = Scroll Look an / aus
	sbr LEDTast,1<<0		; Merker LED's
    rcall TastSend
	rcall NDReset
	sei
loop:
	rjmp	loop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                DisplayTech 162      			;;
;;                                    			;;
;;                                    			;;
;;				  8Bit bertragung     			;;
;;												;;
;; 				DB0-DB7:       PB0-PB7			;;
;; 				RS:            PD5    			;;
;; 				E:             PD4    			;;
;;												;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 
;---- erzeugt den Enable-Impuls zur Befehlsbertragung ----
data2lcd:
           out PORTB, data
  		   sbi PORTD, 4                 ;Enable high
           nop                          ;0,25 mysek Pause
           nop							;0,25 mysek Pause
           nop							;0,25 mysek Pause
		   clr data							;0,25 mysek Pause
		   cbi PORTD, 4                 ;Enable wieder low
		   out PORTB, data				;clear PORTB
		   rcall delay100us				;Delay-Routine aufrufen
		   ret                          ;Und wieder zurck                     

;---- erzeugt den Enable-Impuls zur Textbertragung ----
txt2lcd:
           out PORTB, Status
		   sbi PORTD, 5					;RS	high
		   sbi PORTD, 4                 ;Enable high
           nop                          ;0,25 mysek Pause
           nop							;0,25 mysek Pause
           nop							;0,25 mysek Pause
		   clr Status					;0,25 mysek Pause
		   cbi PORTD, 4                 ;Enable wieder low
		   cbi PORTD, 5					;RS wieder low
		   out PORTB, Status				;clear PORTB
		   rcall delay100us				;Delay-Routine aufrufen
		   ret                          ;Und wieder zurck                     


;---- Pause nach jeder bertragung 100 mysek --------------------
delay100us:                             ;0,1ms Pause
           ldi  counter1, 100			;
delay100us_:nop							;0,25 mysek Pause
		   dec  counter1				;0,25 mysek Pause
           brne delay100us_				;0,50 mysek Pause = 1mysek * 100 = 0,1ms
           ret                          ;Und wieder zurck

;---- Lngere Pause fr manche Befehle 5 ms ----------------------
delay5ms:                               ;5ms Pause
           ldi  counter2, 50			;50 * 0,1ms = 5ms

delay1:                                 ;0,1ms Pause
           ldi  counter1, 100			;
delay1_:   nop							;0,25 mysek Pause
		   dec  counter1    			;0,25 mysek Pause
           brne delay1_  				;0,50 mysek Pause = 1mysek * 100 = 0,1ms

           dec  counter2				;
           brne delay1					;
           ret                          ;Und wieder zurck

;DISPLAY-Initialisierung: muss ganz am Anfang des Programms aufgerufen werden
init_lcd:
           ldi	counter3,3				;3* 5ms = 15ms
powerupwait:							;15ms warten auf Display POWER-UP
           rcall	delay5ms			;
           dec	counter3				;
           brne	powerupwait				;immer noch aufs Display warten
           ldi data, 0b00110000         ;muss 3mal hintereinander gesendet
           out PORTB, data              ;werden zur Initialisierung
           rcall data2lcd               ;1
		   rcall delay5ms				;Beim ersten Befehl 5ms warten!
		   out PORTB, data 				;
		   rcall data2lcd               ;2
           out PORTB, data				;
		   rcall data2lcd               ;und 3!
           
           ldi data, 0b00111000         ;Display: 2 Zeilen 5x8 Dots(8Bit-Modus)
           out PORTB, data				;
           rcall data2lcd				;
           
		   ldi data, 0b00001101         ;Display on, Coursor off, Courser-Blink off;
		   out PORTB, data				;
		   rcall data2lcd				;
		   
		   ret							;Und wieder zurck


;Sendet den Befehl zur Lschung des Displays
clear_lcd:
           ldi data, 0b00000001   		;Display lschen
           rcall data2lcd		  		;
           rcall delay5ms		  		;
		   ret					  		;Und wieder zurck

;**********************HAUPT-Programm***********************

TastInt: 	cli
			RCALL TastIn
            rcall zg
			sei 
			reti
			 
TastIn:		CLR temp			;Das Empfangsbyte leeren
			CLR counter1		;Einen Loop Counter
			RCALL c1kH1
RcvLoop:	RCALL c1kH1			;Einen CLK-Zyklus abwarten
			CLC					;Das Carry-Bit leeren
			SBIC PIND,1			;Wenn logisch "high" anliegt
			SEC					;Carry-Bit setzen
			ROR temp			;und Bit ins Register schieben
			INC counter1
			CPI counter1,8		;7 Bits empfangen
			BRNE RcvLoop
			RCALL C1kH1			;partity Bit abwarten
			RCALL C1kH1         ;Stoppbit abwarten
			;RCALL zg
tiend:		;sei
			;reti
			ret
;*******
C1kH1:
LoopC1kLow:
			SBIC pind,2			;an PIND2 hngt der CLK
			RJMP LoopC1kLow
LoopC1kHigh:
			SBIS pind,2			
			rjmp LoopC1kHigh
			ret
;*****************************

TastSend: ;Data = Zeichen
	ldi counter3,8				; Bitzhler
	sbi ddrd,2					; Port D Bit 2 Ausgang Takt
	cbi portd, 2				; Set Clock low Port D Bit 2 
	ldi counter2,1      		; Counter 2 clr
	ldi Counter1,84   			; Counter 1 auf 64s Warten auf Tastatur min 60S
    rcall delay1_				; Prog 1s Delay
	clr status					; Stautus Register fr Parity verwenden 
    sbi ddrd, 1					; Port D Bit 1 Ausgang Data
	cbi portd, 1				; Port D Bit 1 Ausgang LOW
    cbi ddrd, 2					; Port D Bit 2 Eingang
	sbi portd, 2				; Pull up Widerstand aktive
	rcall C1kH1					; Clock Low - High
TSl1: 
	ror data					;
	brcc tsl2					; Springe Bit 0 
	 sbi portd, 1				; Daten Bit High
	 inc status					; Parity Bit feststellen 	
	rjmp TSl3					;
TSl2:
	 cbi portd, 1				;  Daten Bit LOW
TSl3:
	rcall C1kH1					; Clock  Low - High
	dec counter3				; Bitzhler -1
	brne TSl1					; nchste Bit
	; Ende berttragung 8 Bit
	sbrc status,0
	cbi portd, 1				;2 -6  lsche Parity Bit
	sbrs status,0   			;2 -8	ist rStatus bit 0 =1
	sbi portd, 1				;2 -10  dann setze Parity
    rcall C1kH1					; Clock Low - High
TSLend:
    cbi ddrd,1					; Port D Bit 3 Eingang
	sbi portd, 1				; Port D Bit 3 Pullup wieder an
	rcall C1kH1					; Clock Low -High
	SBIC pind,1					; Data High = Fehler
	rcall TSlerror
TSLend1:
    sbic pind,2
	rjmp TSLend1
	rcall TastIn    
	ret 

TSlerror:
    ;ldi data,0xe5
	;out portb,data
    ;rjmp TSlerror
	ret

;********************************

zg: cpi temp, 0xE0			;E0 Sondertasten
    brne z0
	  clr E0
	  cpi Lastkey,0xF0
	  breq zlend
	  inc E0
	 rjmp zlend
z0:
	cpi temp, 0xf0			;Break Code
    brne z2
	  inc bre			    ;setze Break Flag
      clr E0				;E0 Flag lschen
	  ldi temp,0xA4
      cpi Lastkey,0xE0
      brne zlend
		inc E0Bre			; Setze E0 Break fr wilde Control Shift
z1:	 rjmp zlend
    
z2:	cpi temp,0x11			;Alt
	breq zlA0
	cpi temp,0x14			;Strg
	breq zlC0
	cpi temp,0x58			;CapsLock
	breq zlL0
	tst E0Bre
	brne z3
	cpi temp,0x12			;linke Shift
	breq zlS0
    cpi temp,0x59			;rechte Shift
	breq zlS0
z3:	tst Bre					;testen ob Zeichen nach Break
    breq z					;Break 0 = kein - also Zeichen
	 clr Bre 				;lsche Break Flag
	 clr E0Bre
	 rjmp zlend

zlS0:
	  sbrs LEDTast,2
	   rjmp zlS1 
	  push temp
      ldi data,0xED			; ED fr Lampen Steuerung
      rcall TastSend 
	  cbr LEDTast,1<<2		; Merker LED's
	  mov Data,LEDTast		; Bit 2 = Caps Look  aus
      rcall TastSend
	  pop temp

zlS1: tst Bre		        ;schaue Break 0
	  brne zlS2				;gesetzt Break
	   inc Shift    		;setze Shift
      rjmp zlend
zlS2:
	  clr Shift 				;lsche Shift
 	  clr Bre				;lsche Break Flag
	  clr E0Bre
	 rjmp zlend
zlA0:
	 tst Bre		        ;schaue Break 0
	 brne zlA1				;gesetzt Break
	  clr E0
	  inc Alt	    		;setze Shift
	  rjmp zlend

zlend: mov Lastkey,temp
	   ret
 
zlA1:
     clr Alt 				;lsche Alt
	 clr Bre				;lsche Break Flag
	 clr E0Bre				;Lsche E0 Break Flag 
     rjmp zlend

zlC0: 
	 tst Bre		        ;schaue Break 0
	 brne zlC1				;gesetzt Break
	  clr E0
	  inc Strg	    		;setze Strg
	  rjmp zlend
 
zlC1:
     clr Strg 				;lsche Strg
	 clr Bre				;lsche Break Flag
	 clr E0Bre				;lsche Break Flag
     rjmp zlend

zlL0:
	 tst Bre		        ;schaue Break 0
	 brne zlC1				;gesetzt Break
	  sbrc LEDTast,2
	  rjmp zlL1 
	   inc Shift	    		;setze Strg
       ldi data,0xED			; ED fr Lampen Steuerung
       rcall TastSend 
	   sbr LEDTast,1<<2		; Merker LED's
	   mov Data,LEDTast		; Bit 2 = Num Look an / aus
       rcall TastSend
zlL1: rjmp zlend


z:	mov Lastkey,temp
	clr Data
	tst E0
    breq zo5
	 ldi zl, low(tastzens*2)			;a Zeige auf Z-Pointer Lowbyte von Tabelle
	 ldi zh, high(tastzens*2)			;a Zeige auf Z-Pointer Highbyte von Tabelle
	 tst Shift
	 breq zo2
	   subi temp,0x15					; In Tabelle zwei Wertereihen direk und -0x15
	   brcc zo1
	    ldi Data,1						; Achtung Carry High Adresse
zo1:   rjmp zo9
zo2: tst Alt
	 breq zo3
	 ldi zl, low(tastzeas*2)			;a Zeige auf Z-Pointer Lowbyte von Tabelle
	 ldi zh, high(tastzeas*2)			;a Zeige auf Z-Pointer Highbyte von Tabelle
zo3: tst Strg
	 breq zo4
	 ldi zl, low(tastzeas*2)			;a Zeige auf Z-Pointer Lowbyte von Tabelle
	 ldi zh, high(tastzeas*2)			;a Zeige auf Z-Pointer Highbyte von Tabelle
      subi temp,0x15					; In Tabelle zwei Wertereihen direk und -0x15
	  brcc zo4
	   ldi Data,1 						;Achtung Carry high Adresse
zo4: rjmp zo9
zo5:
	tst Strg 						;Strg aktive
    breq zo6
	 ldi zl, low(tastzs*2)			;a Zeige auf Z-Pointer Lowbyte von Tabelle
	 ldi zh, high(tastzs*2)			;a Zeige auf Z-Pointer Highbyte von Tabelle
    rjmp zo9 
zo6:
	tst Alt							;Alt aktive
    breq zo7
	 ldi zl, low(tastza*2)			;a Zeige auf Z-Pointer Lowbyte von Tabelle
	 ldi zh, high(tastza*2)			;a Zeige auf Z-Pointer Highbyte von Tabelle
    rjmp zo9 
zo7:
	tst Shift						;Zeichen ausgeben
	brne zo8						;wenn keine Shift Taste gedrckt wurde
	 ldi zl, low(tastzk*2)			;a Zeige auf Z-Pointer Lowbyte von Tabelle
	 ldi zh, high(tastzk*2)			;a Zeige auf Z-Pointer Highbyte von Tabelle
	rjmp zo9
zo8: ldi zl, low(tastzg*2)			;A Zeige auf Z-Pointer Lowbyte von Tabelle
	 ldi zh, high(tastzg*2)			;A Zeige auf Z-Pointer Highbyte von Tabelle
zo9:		add zl, temp			; Scancode und Zeichen abgleichen
            brcc zo10
			 inc zh 				;bertrag zu High addieren
zo10:		sub zh, data			; Carry aus E0
   			lpm						; lade R0 mit Wert auf der der Z-Pointer zeigt
		    mov temp,status

			tst	status				;Statusregister prfen
			breq	charend			;Statusreg = 0x00 Textausgabe beendet
			cpi temp,0xff			;Reset Ausgang
			breq NDReset

test:		 cpi temp,0x80			;Doppelzeichen wenn 80 bis a0
			 brcs zo40   			;>80 Zeichen direkt ausgeben
			  cpi temp,0xa0
			  brcs zo11				;>A0 2 Zeichen
			   cpi temp,0xb0		
			   brcs zo12			;>B0 16 Zeichen
			  rjmp zo40		  

zo11:         ldi CharCoun,0x02			;Zeichenzhler max 2 Zeichen
 			  subi temp,0x80
	  		  ldi zl, low(Tab2Char*2)	;A Zeige auf Z-Pointer Lowbyte von Tabelle
	 		  ldi zh, high(Tab2Char*2)	;A Zeige auf Z-Pointer Highbyte von Tabelle
			  rcall zo20	
			  ret

zo12:		  ldi CharCoun,16			;Zeichenzhler max 16 Zeichen
 			  subi temp,0xA0
	  		  ldi zl, low(Tab16Char*2)	;A Zeige auf Z-Pointer Lowbyte von Tabelle
	 		  ldi zh, high(Tab16Char*2) ;A Zeige auf Z-Pointer Highbyte von Tabelle
     		  rcall zo20				; Zeichenausgabe >= A0 	
			  ret
				
zo20:		  push CharCoun
zo21:    	   add zl, temp				; Scancode und Zeichen abgleichen
              brcc zo22
 			   inc zh 					;bertrag zu High addieren
zo22:         dec CharCoun
              brne zo21
			 pop CharCoun
zo23:        lpm
             mov temp,status
			 tst	status				;Statusregister prfen
			 breq zo25					;Statusreg = 0x00 Textausgabe beendet
             rcall zo40
			 inc zl
             brne zo24
 			  inc zh 					;bertrag zu High addieren
zo24:        dec CharCoun
             brne zo23
zo25:		 ret


zo40:		 cpi temp,0x20			;Zeichen nicht auf Display
			 brcs zo42
			 rcall NDROut
zo41:        rcall LCDChar         ; Zeichen auf Display
			 ret
zo42:	     rcall NDROut
			 rcall CharHex
			 ret
	;out PORTB, temp
NDROut:		
			out portB,temp
			sbi portd, 3
			cbi portd, 3
		    rcall delay5ms
			
charend:	ret

NDReset:    cbi portd, 6
			rcall delay5ms
			sbi portd, 6
			ret

LCDChar:
	       	rcall txt2lcd			;Zeichen ans Display bertragen
			inc LCDYX
			cpi LCDYX,0b10010000    ;=grer 16 Zeichen
			breq LCDYX1
			cpi LCDYX,0b11010000    ;=grer 16 Zeichen
			breq LCDYX11
			ret
LCDYX1:     ldi data,0b11000000    ;Zeile 1 Weiter
			mov LCDYX, data
            rcall data2lcd
			ret
LCDYX11:     ldi data,0b10000000    ;Zeile 1 Weiter
			mov LCDYX, data
            rcall data2lcd
			ret

CharHex:    ldi counter1,0xA5
		    mov status,counter1
		    rcall LCDChar
		    mov counter1,temp
			swap counter1
			ldi counter2,0x0f
			and counter1,counter2
			rcall ch1
			mov  counter1,temp
			ldi counter2,0x0f
			and counter1,counter2
			rcall ch1
			ret 
ch1:		cpi counter1,0x0a
			brge ch2
			 ldi counter2,0x30
			 add counter1,counter2
            rjmp chout
ch2:
			 ldi Counter2, 0x37
			 add counter1,counter2
chout:		mov status,counter1
			rcall LCDChar
			ret

tastzk:		; alle Zeichen kleiner 0x20 zum testen mit 0xAx 0xBx ausgegeben
;     00   01   02   03   04   05   06   07   08   09   0A   0B   0C   0D   0E   0F 
.db 0x00,0x00,0x00,0x83,0x00,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;00                           F1
.db 0x00,0x00,0x00,0x00,0x00,0x71,0x31,0x00,0x00,0x00,0x79,0x73,0x61,0x77,0x32,0x00
;10                           q    1                   y    s    a    w    2              
.db 0x00,0x63,0x78,0x64,0x65,0x34,0x33,0x00,0x00,0x20,0x76,0x66,0x74,0x72,0x35,0x00
;20       c    x    d    e    4    3             Space v	f    t    r    5    
.db 0x00,0x6E,0x62,0x68,0x67,0x7A,0x36,0x00,0x00,0x00,0x6D,0x6A,0x75,0x37,0x38,0x00
;30       n    b    h    g    z    6                   m    j    u    7    8      
.db 0x00,0x2c,0x6B,0x69,0x6F,0x30,0x39,0x00,0x00,0x2E,0x2D,0x6C,0x7c,0x70,0x7E,0x00
;40       ,    k    i    o    0    9              .    -    l        p          
.db 0x00,0x00,0x7b,0x00,0x7d,0x00,0x00,0x00,0x00,0x00,0x0D,0x2B,0x00,0x23,0x00,0x00
;50                                                 Enter +         #
.db 0x00,0x3C,0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0x31,0x00,0x34,0x37,0x00,0x00,0x00
;60       <                       Backspace      N1        N4   N7
.db 0x30,0x2C,0x32,0x35,0x36,0x38,0x1B,0x00,0x00,0x2b,0x33,0x2D,0x2A,0x39,0x00,0x00
;70 N0   N,   N2   N5   N6   N8   ESC             +    3    -    *    9
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;80

tastzg:
;     00   01   02   03   04   05   06   07   08   09   0A   0B   0C   0D   0E   0F 
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;00
.db 0x00,0x00,0x00,0x00,0x00,0x51,0x21,0x00,0x00,0x00,0x59,0x53,0x41,0x57,0x22,0x00
;10                           Q    !                   Y    S    A    W    "              
.db 0x00,0x43,0x58,0x44,0x45,0x24,0x00,0x00,0x00,0x20,0x56,0x46,0x54,0x52,0x25,0x00
;20       C    X    D    E    $                 Space V	F    T    R    %    
.db 0x00,0x4E,0x42,0x48,0x47,0x5A,0x26,0x00,0x00,0x00,0x4D,0x4A,0x55,0x2f,0x28,0x00
;30       N    B    H    G    Z    &                   M    J    U    /    (      
.db 0x00,0x3B,0x4B,0x49,0x4F,0x3D,0x29,0x00,0x00,0x3A,0x00,0x4C,0x5c,0x50,0x3F,0x00
;40       ;    K    I    O    =    )              :    _    L        P    ?      
.db 0x00,0x00,0x5B,0x00,0x5D,0x60,0x00,0x00,0x00,0x00,0x0D,0x2A,0x27,0x27,0x00,0x00
;50                          `                      Enter *         '
.db 0x00,0x3E,0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0x31,0x00,0x34,0x37,0x00,0x00,0x00
;60       >                       Backspace      N1        N4   N7
.db 0x30,0x2C,0x32,0x35,0x36,0x38,0x1B,0x00,0x00,0x2B,0x33,0x2D,0x2A,0x39,0x00,0x00
;70 N0   N,   N2   N5   N6   N8   ESC            N+   N3   N-   N*   N9
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;80

tastzens:; direk F8 Pie +  Shift + F5 Omega
;     00   01   02   03   04   05   06   07   08   09   0A   0B   0C   0D   0E   0F 
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;00                                                   +WinL           
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;10           +WinR                                   +WinM                    WinL
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;20           +Powe                    WinR           +Slee                    WinM
.db 0x00,0x00,0x00,0x00,0x00,0x2f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;30                          +N/       Powe                                    Slee
.db 0x00,0x00,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x00,0x2F,0x00,0x00,0x00,0x00,0x00
;40                          +NEn                +Wak N/
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0x14,0x00,0x00,0x00,0x00
;50						+End      +CLi +Pos           NEnt +Ein +Ent +CRu Wake +CRe
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00
;60 +CHo                     +BRu      +Dru +BHo Ende      CLin Pos
.db 0x16,0x07,0x18,0x00,0x04,0x05,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x12,0x00,0x00
;70 Einf Entf CRun      CRec CHoc                     BRun      Druc BHoc
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;80                 

tastzeas:; Alt Winl +Strg +WinL
;     00   01   02   03   04   05   06   07   08   09   0A   0B   0C   0D   0E   0F 
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;00                                                   +WinL           
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;10           +WinR                                   +WinM                    WinL
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;20           +Powe                    WinR           +Slee                    WinM
.db 0x00,0x00,0x00,0x00,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;30                          +N/       Powe                                    Slee
.db 0x00,0x00,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x00,0x2F,0x00,0x00,0x00,0x00,0x00
;40                          +NEn                +Wak N/
.db 0x00,0x00,0x00,0x00,0x82,0x00,0x01,0x81,0x00,0x00,0x0d,0x15,0x00,0x1A,0x00,0x06
;50						+End      +CLi +Pos           NEnt +Ein +Ent +CRu Wake +CRe
.db 0x17,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;60 +CHo                     +BRu      +Dru +BHo Ende      CLin Pos
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;70 Einf Entf CRun      CRec CHoc                     BRun      Druc BHoc
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;80                 

tastza:		; alle Zeichen kleiner 0x20 zum testen mit 0xAx 0xBx ausgegeben
;     00   01   02   03   04   05   06   07   08   09   0A   0B   0C   0D   0E   0F 
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00
;00
.db 0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x8a,0x83,0x91,0x84,0x00,0x00
;10                           @    1                   y    s    a    w    2              
.db 0x00,0x88,0xd8,0xc4,0xc5,0x00,0x00,0x00,0x00,0x20,0x89,0x90,0x8d,0x8f,0x00,0x00
;20       c    x    d    e    4    3             Space v	f    t    r    5    
.db 0x00,0xcE,0x8b,0x87,0xc7,0xdA,0x36,0x00,0x00,0x00,0xcD,0xcA,0xd5,0x7B,0x5B,0x00
;30       n    b    h    g    z    6                   m    j    u    {    [      
.db 0x00,0x00,0xcB,0x8e,0xcF,0x7D,0x5D,0x00,0x00,0x2E,0x2D,0x8c,0x00,0xd0,0x5C,0x00
;40       ,    k    i    o    }    ]              .    -    l         p    \      
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x00,0x00
;50                                                   Enter ~         #
.db 0x00,0x7C,0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0x31,0x00,0x34,0x37,0x00,0x00,0x00
;60       |                                      N1        N4   N7
.db 0x00,0x2C,0x32,0x00,0x00,0x00,0x1B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;70 N0   N,   N2   N5   N6   N8   ESC            N+   N3   N-   N*   N9
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;80

tastzs:		; Strg Tabelle
;     00   01   02   03   04   05   06   07   08   09   0A   0B   0C   0D   0E   0F 
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1B,0x00
;00
.db 0x00,0x00,0x00,0x00,0x00,0x11,0x1C,0x00,0x00,0x00,0x19,0x13,0x01,0x17,0x1D,0x00
;10                           q    1                   y    s    a    w    2              
.db 0x00,0x03,0x18,0x04,0x05,0x34,0x1E,0x00,0x00,0x20,0x16,0x06,0x14,0x12,0x35,0x00
;20       c    x    d    e    4    3             Space v	f    t    r    5    
.db 0x00,0x0E,0x02,0x08,0x07,0x1A,0x36,0x00,0x00,0x00,0x0D,0x0A,0x15,0x60,0x7B,0x00
;30       n    b    h    g    z    6                   m    j    u    7    8      
.db 0x00,0x00,0x0B,0x09,0x0F,0x00,0x7D,0x00,0x00,0x5D,0x7C,0x0C,0x00,0x10,0x5C,0x00
;40       ,    k    i    o    0    9              .    -    l         p          
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x40,0x00,0x7E,0x00,0x00
;50                                                   Enter +         #
.db 0x00,0x7F,0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0xA1,0x00,0xA4,0x37,0x00,0x00,0x00
;60       >                                      N1        N4   N7
.db 0xA0,0x2C,0xA2,0xA5,0xA6,0xA8,0xff,0x00,0x00,0x2B,0xA3,0x2D,0x2A,0xA9,0x00,0x00
;70 N0   N,   N2   N5   N6   N8   ESC            N+   N3   N-   N*   N9
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;80

Tab2Char: ; immer zwei Zeichen ausgeben
;   00 08     01 09     02 0A     03 0B     04 0C     05 0D     06 0E     07 0F 
.db 0x0B,0x18,0x11,0x12,0x11,0x03,0x11,0x03,0x11,0x13,0x0b,0x02,0x0b,0x0b,0x0b,0x08
;80 Alt F4^KX ^Pos ^QR  ^Ende ^QC AltF3 AlS AltW F3   Alt Pos   Alt Ende  Alt H
.db 0x0b,0x03,0x0b,0x16,0x0b,0x19,0x0b,0x13,0x0b,0x0c,0x0b,0x14,0x0b,0x09,0x0b,0x12
;88 Alt C     Alt V     Alt Y     Alt S     Alt L     Alt T     Alt I     Alt R          
.db 0x0b,0x17,0x0b,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;90 Alt W     F2 Alt A
.db 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
;98              

;80 Alt F4 	   		= ^KX	   = Ende Editor
;81 ^Pos	   		= ^QR   	   = Datei Anfang
;82 ^Ende      		= ^QC   	   = Datei Ende
;83 Alt S    Alt F3 = ^QF 	   = Suchen
;84 Alt W    F3  	= ^QA	   = Ersetzen
;85 Alt Pos    = ^QB ^KB   = Blockanfang
;86 Alt Ende   = ^QK ^KK   = Blockanfang
;87 Alt H      = ^QH ^KH   = Blockmarken lschen
;88 Alt C      = ^KC       = Block Kopieren
;89 Alt V      = ^KV       = Block verschieben
;8A Alt Y      = (^KY)     = Block lschen
;8B Alt B      = ^KS       = Block auf Diskette schreiben
;8C Alt L      = ^KL       = Block von Diskette laden
;8D Alt T      = ^KT       = Text auf Diskette schreiben
;8E Alt I      = ^KI       = Dir Diskette
;8F Alt R      = ^KR       = Lesen 
;90 Alt F      = ^KW       = Schreiben
;91 F2 Alt A   = ^KA       = Assembler
Tab16Char:
;	 1234567890123456
.db "lea Speicher,a0",0x0d 			;A0 Strg Num 0 
.db "$FFFFFF",0,0,0,0,0,0,0,0,0		;A1 Strg Num 1
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 2
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 3
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 4
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 5
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 6
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 7
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 8
.db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;A1 Strg Num 9