             ********************************************
             ***'                                    '***
             ***'.......SRAMDISK Testprogramm........'***
             ***'                                    '***
             ***'                                    '***
             ***'  (P)+(C) 2007  Gerald Ebert        '***
             ***'                                    '***
             ********************************************

*>>>>>>>    LABELS

cpu         equ   2                       * M68000/10

sdbase      equ   $ffffff2c               * Basis I/O-Adresse ($2C-$2F)

sddata      equ   (sdbase+0)*cpu          * Daten Register
sdsectl     equ   (s2base+1)*cpu          * Sektor Register Low Byte
sdsecth     equ   (s2base+2)*cpu          * Sektor Register High Byte

sdsectsz    equ   1024                    * Sektorgroesse in Bytes

*>>>>>>     START DES TESTPROGRAMMS

            clr      d0
            lea      $20000, a0
            movea.l  a0, a1
loop1:      move.b   d0, (a1)+            * Erzeuge 4 Zahlenreihen 0...255
            addq     #1, d0
            cmp      #sdsectsz, d0
            blo.s    loop1
            clr      d0                   * Sektornummer 0 laden
            bsr      sdwrite              * Sektor in SRAMDISK schreiben
            lea      $21000, a0
            bsr      sdread               * Gleichen Sektor an andere Stelle lesen
            movea.l  a0, a1
            lea      $20000, a0
            move     #(sdsectsz/4)-1, d0  * Sektorlaenge (eigentlich 4-Byte-Bloecke)
loop2:      move.l   (a0)+, d1
            cmp.l    (a1)+, d1            * Vergleiche beide Puffer
            bne.s    error                * Fehler: Puffer nicht gleich
            dbra     d0, loop2            * bis alle Bytes verglichen sind
            lea      oktext(pc), a0       * OK: Puffer sind gleich
            bra.s    ausgabe              * Gib entsprechenden Text aus
error:      lea      failtext(pc), a0
ausgabe:    move.b   (a0)+, d0            * Zeichen in d0 laden
            beq.s    ende                 * Letztes Zeichen -> Fertig.
            moveq    #!CO, d7             * Zeichen in d0 ausgeben
            trap     #1
            bra.s    ausgabe              * nchstes Zeichen
ende:       rts                           * ENDE


oktext:     dc.b     'Sektor in SRAMDISK korrekt geschrieben.', 13, 10, 0
failtext:   dc.b     'Fehler in SRAMDISK Daten.', 13, 10, 0



*>>>>>>     LESE SEKTOR VON SRAMDISK
;'          d0 => Sektornummer
;'          a0 => Pufferadresse (Ziel)

sdread:     movem.l  d0/a0/a1, -(a7)
            lea      sddata.w, a1         * Lade Datenregisteradresse
            move.b   d0, sdsectl.w        * Setze Sektornummer Low Byte
            lsr      #8, d0
            move.b   d0, sdsecth.w        * Setze Sektornummer High Byte
            moveq    #(sdsectsz/8)-1, d0  * Anzahl Bloecke fuer Zaehler
sdrdloop:   move.b   (a1), (a0)+          * bertrage ein Byte in den Puffer
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+          * Block gelesen
            dbra     d0, sdrdloop         * Lese gesamten Sektor
            movem.l  (a7)+, d0/a0/a1
            rts

*>>>>>>     SCHREIBE SEKTOR IN SRAMDISK
;'          d0 => Sektornummer
;'          a0 => Pufferadresse (Quelle)

sdwrite:    movem.l  d0/a0/a1, -(a7)
            lea      sddata.w, a1         * Lade Datenregisteradresse
            move.b   d0, sdsectl.w        * Setze Sektornummer Low Byte
            lsr      #8, d0
            move.b   d0, sdsecth.w        * Setze Sektornummer High Byte
            moveq    #(sdsectsz/8)-1, d0  * Anzahl Bloecke fuer Zaehler
sdwrloop:   move.b   (a0)+, (a1)          * bertrage ein Byte zur SRAMDISK
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)          * Block geschrieben
            dbra     d0, sdwrloop         * Schreibe gesamten Sektor
            movem.l  (a7)+, d0/a0/a1
            rts

*>>>>>>     BAUGRUPPEN-ERKENNUNG
;'          d0 <= Ergebnis:  0 = nicht vorhanden / nicht bestueckt
;'                           1 = Kapazitaet  512 kB
;'                           2 = Kapazitaet 1024 kB
;'                           3 = Kapazitaet 1536 kB
;'                           4 = Kapazitaet 2048 kB

sdident:    movem.l  a0/a1, -(a7)
            lea      sddata.w, a1         * Lade Datenregisteradresse
            move     #0, d0               * Sektor #0
            bsr.s    sdidtst              * Teste, ob Sektor vorhanden
            bcc.s    sdident1             * OK, weiter testen
            moveq    #0, d0               * Ergebnis 'nicht vorhanden'
            bra.s    sdidente
sdident1:   move     #512, d0             * Sektor #512
            bsr.s    sdidtst              * Teste, ob Sektor vorhanden
            bcc.s    sdident2             * OK, weiter testen
            moveq    #1, d0               * Ergebnis 'Kapazitaet 512 kB'
            bra.s    sdidente
sdident2:   move     #1024, d0            * Sektor #1024
            bsr.s    sdidtst              * Teste, ob Sektor vorhanden
            bcc.s    sdident3             * OK, weiter testen
            moveq    #2, d0               * Ergebnis 'Kapazitaet 1024 kB'
            bra.s    sdidente
sdident3:   move     #1536, d0            * Sektor #1536
            bsr.s    sdidtst              * Teste, ob Sektor vorhanden
            bcc.s    sdident4             * OK, Baugruppe voll bestueckt
            moveq    #3, d0               * Ergebnis 'Kapazitaet 1536 kB'
            bra.s    sdidente
sdident4:   moveq    #4, d0               * Ergebnis 'Kapazitaet 2048 kB'
sdidente:   movem.l  (a7)+, a0/a1
            rts

sdidtst:    move.b   d0, sdsectl.w        * Setze Sektornummer Low Byte
            lsr      #8, d0
            move.b   d0, sdsecth.w        * Setze Sektornummer High Byte
            lea      sdbuf1(pc), a0
            move.b   (a1), (a0)+          * Sichere aktuelle Inhalt
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   d0, sdsecth.w        * Setze Bytezaehler zurck
            lea      sdkenn(pc), a0
            move.b   (a0)+, (a1)          * Schreibe Kennung in Sektor
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   d0, sdsecth.w        * Setze Bytezaehler zurck
            lea      sdbuf2(pc), a0
            move.b   (a1), (a0)+          * Lese Kennung wieder in Puffer
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   (a1), (a0)+
            move.b   d0, sdsecth.w        * Setze Bytezaehler zurck
            lea      sdbuf1(pc), a0
            move.b   (a0)+, (a1)          * Stelle Inhalt des Sektor wieder her
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.b   (a0)+, (a1)
            move.l   sdbuf2(pc), d0       * Vergleiche Kennung nach Schreiben
            cmp.l    sdkenn(pc), d0       * und Lesen aus Sektor
            beq.s    sdidtst1             * -> Sektor vorhanden
            andi     #$fe, ccr            * Sektor nicht vorhanden, C = 1
            rts
sdidtst1:   ori      #$01, ccr            * Sektor vorhanden, C = 0
            rts

sdkenn:     dc.l     $55AA33CC            * Kennung fuer Pruefung
sdbuf1:     ds.l     1                    * Puffer zur Sicherung des Sektorinhalts
sdbuf2:     ds.l     1                    * Puffer zum Lesen der Kennung aus Sektor

            end
