/* CBASE.H */
#ifndef CBASE_H
#define CBASE_H


#include <stdio.h>
#include <stdint.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include "../../nkc_common/nkc/nkc.h"



/* ===============================
   CBASE – Grundkonfiguration
   =============================== */

/* Version */
#define CBASE_NAME        "CBASE"
#define CBASE_VERSION     "0.2"

/* Prompt */
#define CBASE_PROMPT      "."

/* ===============================
   Tasten / Eingaben
   =============================== */

/* Steuerzeichen */
#define KEY_ESC           0x1bu
#define KEY_RETURN        0x0Du
#define KEY_NEWLINE       '\n'
#define KEY_UP            0x05u
#define KEY_DOWN          0x18u
#define KEY_LEFT          0x13u
#define KEY_RIGHT         0x04u

#define KEY_BACKSPACE     0x08u
#define KEY_BACKSPACE2    0x7fu





/* Paging */
#define KEY_QUIT_UPPER    'Q'
#define KEY_QUIT_LOWER    'q'

/* Ja / Nein */
#define KEY_YES_UPPER     'J'
#define KEY_YES_LOWER     'j'
#define KEY_NO_UPPER      'N'
#define KEY_NO_LOWER      'n'

/* ===============================
   Verhalten
   =============================== */

/* ESC bricht Dialoge ab */
#define CBASE_ESC_ABORTS  1

/* ===============================
   Rückgabecodes für Dialoge
   =============================== */

#define DLG_ABORT         -1
#define DLG_NO             0
#define DLG_YES            1
#define DLG_CONTINUE       2

/* ===============================
    Rückgabecodes für APPEND
   =============================== */


#define APPEND_CONTINUE  1
#define APPEND_DONE      0
#define APPEND_SKIP     -1
#define APPEND_ABORT    -2


#define APPEND_FIELD_OK     0
#define APPEND_FIELD_RETRY  1
#define APPEND_FIELD_ABORT -1

/* ===============================
    Rückgabewerte für EDIT
   =============================== */


#define EDIT_DONE     1
#define EDIT_ABORT    0

#define FIELD_NEXT    1
#define FIELD_PREV   -1
#define FIELD_EXIT    0

/* ================================
    Definitionen für SET
================================ */

/* DATUMs Anzeige und Eingabe format*/
/* Interne Speicherung bleibt immer YYYYMMDD */
/* Anzeige- / Eingabeformate */
#define DATEFMT_DDMMYYYY   1   /* 31.12.2024 */
#define DATEFMT_MMDDYYYY   2   /* 12/31/2024 */
#define DATEFMT_YYYYMMDD   3   /* 2024-12-31 */

/* aktuelles Systemformat */
#define DATEFORMAT DATEFMT_DDMMYYYY




#define DB_NAME_LEN 32

// Dateityp Suffixe
#define DB_SUFFIX ".DBF"

/* --- JADOS API --- */

struct jdfcb;



/* --- dBASE III Strukturen --- */

#pragma pack(push, 1)

typedef struct {
    uint8_t  version;
    uint8_t  yy, mm, dd;
    uint32_t num_records;
    uint16_t header_len;
    uint16_t record_len;
    uint8_t  reserved[20];
} dbf_header_t;


typedef struct { 
    char     name[11];
    char     type;
    uint32_t offset;
    uint8_t  length;
    uint8_t  decimals;
    uint8_t  reserved[14];
} dbf_field_t;

#pragma pack(pop)

/* --- cBASE Datenbank-Handle --- */

typedef struct {
    struct jdfcb fcb;

    uint8_t *buf;       /* kompletter DBF-Inhalt im RAM */
    size_t   buf_len;   /* fcb.length * 1024 */
    dbf_header_t header;

    dbf_field_t fields[16];
    int field_count;

    char name[DB_NAME_LEN]; /*aktueller Datenbankname*/
    int dirty;              /* Dirty Flag, wird bei Änderung aktiviert*/

    /* für Navigation in der Datenbank */
    uint32_t current_rec;
    uint8_t  eof;
    uint8_t  bof;

} db_t;

// Enum für Anzeigemodus für logisch gelöschte Datensätze
typedef enum {
    DB_SHOW_NORMAL = 0,
    DB_SHOW_DELETED = 1
} db_show_mode_t;

// Struct für LOCATE
typedef enum {
    LOC_OP_EQ,
    LOC_OP_NE,
    LOC_OP_LT,
    LOC_OP_LE,
    LOC_OP_GT,
    LOC_OP_GE,
    LOC_OP_CONTAINS   /* für C */
} locate_op_t;

typedef enum {
    LOC_TYPE_CHAR,
    LOC_TYPE_NUM
} locate_type_t;


typedef struct {
    int active;

    int field_index;
    char field_type;          /* 'C', 'N', 'F' aus DBF */

    locate_type_t type;       /* LOC_TYPE_CHAR / LOC_TYPE_NUM */
    locate_op_t   op;

    char   str_value[64];
    double num_value;
} locate_ctx_t;



// Enum für EXPORT
typedef enum {
    DB_EXPORT_CURRENT,
    DB_EXPORT_ALL,
    DB_EXPORT_LOC
} db_export_mode_t;


// Strukturen für CREATE

#define MAX_CREATE_FIELDS 64

typedef struct {
    char     name[11];
    char     type;
    uint8_t  length;
    uint8_t  decimals;
} create_field_t;

typedef struct {
    create_field_t fields[MAX_CREATE_FIELDS];
    int      field_count;
    uint16_t record_len;
} create_ctx_t;

// Strukturen und Enums für EDIT, APPEND, INSERT
typedef enum {
    INPUT_APPEND,
    INPUT_EDIT
} input_mode_t;


#endif
