/* CBASE.H */

#ifndef DB_H
#define DB_H

#include <stdio.h>
#include <stdint.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include "../../nkc_common/nkc/nkc.h"




/* --- Öffentliche API --- */

int  db_open(db_t *db, const char *name);
void db_close(db_t *db);
void db_list(db_t *db);
void db_info(const db_t *db);
int db_delete_record(db_t *db, uint32_t recno);
int db_undel(db_t *db, uint32_t recno);
int db_pack(db_t *db);
int db_save(db_t *db);
int db_copy(db_t *db, const char *name);




/* SKIP für Navigation */
void db_skip(db_t *db, int32_t delta);


/* interne Navigation */
int db_goto_record(db_t *db, uint32_t recno);
int db_goto_top(db_t *db);
int db_goto_bottom(db_t *db);



#endif /* DB_H */
