/* HELP.C */

#include <stdio.h>
#include <string.h>
#include "help.h"

void help_general(void)
{
    printf(
        "\nVerfuegbare Kommandos:\n"
        " Datenbank: \n"
        " CREATE, USE, SAVE, PACK, COPY, EXPORT, INFO, CLOSE\n\n"
        " Datensatz bearbeiten:\n"
        " APPEND, INSERT, EDIT, DEL, UNDEL\n\n"
        " Navigation in der Datenbank: \n"
        " GOTO, SKIP\n\n"
        " Datensaetze suchen, sortieren\n"
        " LOCATE, CONT, SORT\n\n"
        " Anzeigen: \n"
        " SHOW\n\n"
        " System:\n"
        " CLS, DIR, HELP, CBASE, PROJEKT\n"
        "\n"    );
}

void help_command(const char *cmd)
{
    if (!strcmp(cmd, "USE")) {
        printf(
            "\nUSE  Datenbank oeffnen\n"
            "\n"
            "Syntax:\n"
            "  USE <Name>\n"
            "  USE DIR\n"
            "\n"
            "Beschreibung:\n"
            "  USE <Name> oeffnet Datenbank <Name> \n"
            "  Dateisuffix .DBF wird automatisch ergaenzt.\n\n"
            "  USE DIR zeigt die Datenbanken (*.DBF)\n"
            "  im aktuellen Laufwerk an.\n"
            "  Wenn eine veraenderte Datenbank noch geoeffnet ist,\n"
            "  wird eine Sicherheitsabfrage gestellt."
        );
        return;
    }

    if (!strcmp(cmd, "SAVE")) {
        printf(
            "\nSAVE  Datenbank speichern\n"
            "\n"
            "Syntax:\n"
            "  SAVE \n"
            "\n"
            "Beschreibung:\n"
            "  Aktuelle geoeffnete Datenbank wird in die\n"
            "  bestehende Datei zurueckgespeichert.\n"
            "  Als geloescht markierte Datensaetze bleiben\n"
            "  erhalten.\n"
        );
        return;
    }

    if (!strcmp(cmd, "PACK")) {
        printf(
            "\nPACK  gelöscht markierte Datensaetze entfernen\n"
            "\n"
            "Syntax:\n"
            "  PACK \n"
            "\n"
            "Beschreibung:\n"
            "  Als geloescht markierte Datensaetze werden\n"
            "  entfernt. Die Datensatzorganisation wird neu erstellt.\n"
            "  PACK speichert die aktuelle Datenbank sofort\n"
        );
        return;
    }



    if (!strcmp(cmd, "COPY")) {
        printf(
            "\nCOPY  Datenbank kopieren\n"
            "\n"
            "Syntax:\n"
            "  COPY <Datei>\n"
            "  COPY LOC <Datei>\n"
            "  COPY DIR\n"
            "\n"
            "Beschreibung:\n"
            "  Kopiert Datenbank  in neue Datenbank <Datei> \n"
            "  Dateisuffix .DBF wird automatisch ergaenzt\n"
            "  Alle Datensaetze werden kopiert, auch geloescht markierte\n"
            "  Bei vorhandener Zieldatei <Datei> kommt eine Sicherheitsabfrage.\n\n"
            "  COPY LOC kopiert die LOCATE Selektion in eine <Datei>\n"
            "  COPY DIR zeigt die Datenbanken (*.DBF)\n"
            "  im aktuellen Laufwerk an.\n"
        );
        return;
    }

    if (!strcmp(cmd, "EXPORT")) {
        printf(
            "\nEXPORT  Datenbank exportieren\n"
            "\n"
            "Syntax:\n"
            "  EXPORT <Datei>\n"
            "  EXPORT ALL <Datei>\n"
            "  EXPORT LOC <Datei>\n"
            "  EXPORT DIR\n"
            "\n"
            "Beschreibung:\n"
            "  Exportiert Daten in eine Textdatei <Datei> (CSV) \n"
            "  Dateisuffix .CSV wird automatisch ergaenzt\n"
            "  EXPORT <Datei> exportiert den aktuelen Datensatz in CSV-Datei."
            "  EXPORT ALL: Alle Datensaetze werden exportiert, ohne geloescht markierte\n"
            "  Bei vorhandener Zieldatei <Datei> kommt eine Sicherheitsabfrage.\n\n"
            "  EXPORT LOC exportiert die LOCATE Selektion in eine <Datei>\n"
            "  EXPORT DIR zeigt die Exportdateien (*.CSV)\n"
            "  im aktuellen Laufwerk an.\n"
        );
        return;
    }

    if (!strcmp(cmd, "SORT")) {
        printf(
            "\nSORT  Datenbank sortieren und in Datei ausgeben\n"
            "\n"
            "Syntax:\n"
            "  SORT ON <Feld> [DESC][,<Feld> [DESC]]... TO <Datei> \n"
            "\n"
            "Beschreibung:\n"
            "  Mit SORT ueber ein <feld> (oder mehrere Felder durch Komma getrennt),\n"
            "  wird die offene Datenbank in eine neue Datenbank\n"
            "  in der Sortierreihenfolge ASC gespeichert.\n"
            "  Hinter einem <Feld> kann mit DESC, die Sortierung genau\n"
            "  fuer dieses Feld umgestellt werden.\n"
            "  Standardsortierung ist ASC (aufsteigend), ueber den \n"
            "  Parameter DESC kann absteigende Sortierung gewaehlt werden.\n"
            "  Es sind maximal 8 Sortierfelder zulaessig.\n"
        );
        return;
    }


    if (!strcmp(cmd, "CLOSE")) {
        printf(
            "\nCLOSE  Datenbank schliessen\n"
            "\n"
            "Syntax:\n"
            "  CLOSE \n"
            "\n"
            "Beschreibung:\n"
            "  Aktuelle geoeffnete Datenbank wird geschlossen.\n"
            "  Es werden keine Daten gespeichert.\n"
            "  Aenderungen seit dem letzten Oeffnen gehen verloren.\n"
            "  Wenn Datenbank noch nicht gespeichert wurde,\n"
            "  wird eine Sicherheitsabfrage gestellt."
        );
        return;
    }

    if (!strcmp(cmd, "APPEND")) {
        printf(
            "\nAPPEND  Neuen Datensatz eingeben\n"
            "\n"
            "Syntax:\n"
            "  APPEND \n"
            "\n"
            "Beschreibung:\n"
            "  Mit APPEND wird ein neuer Datensatz am Ende der\n"
            "  der geoeffneten Datenbank angehaengt.\n"
        );
        return;
    }

        if (!strcmp(cmd, "INSERT")) {
        printf(
            "\nINSERT  Neuen Datensatz anlegen\n"
            "\n"
            "Syntax:\n"
            "  INSERT [BLANK] <nr> \n"
            "  INSERT AFTER [BLANK] <nr>\n"
            "  INSERT BEFORE [BLANK] <nr>\n"
            "\n"
            "Beschreibung:\n"
            "  Mit INSERT wird ein neuer Datensatz angelegt.\n"
            "  Default ist die Opton AFTER. D.h., der neue Datensatz\n"
            "  wird direkt hinter der Datensatznummer <nr> erzeugt.\n"
            "  Mit der Option BEFORE wird der Datensatz vor der \n"
            "  Datensatznummer <nr> erzeugt.\n"
            "  Mit der Option BLANK wird nur ein leerer Datensatz angelegt.\n"
        );
        return;
    }

        if (!strcmp(cmd, "EDIT")) {
        printf(
            "\nEDIT  Datensatz bearbeiten\n"
            "\n"
            "Syntax:\n"
            "  EDIT <nr>\n"
            "\n"
            "Beschreibung:\n"
            "  Mit EDIT wird ein Datensatz editiert.\n"
            "  EDIT <nr> editiert den Datensatz <nr>.\n"
            "  EDIT editiert den aktuelle Datensatz.\n"
            "  In der Erfassungsmaske kann mit Pfeil auf/ab \n"
            "  navigiert werden.\n"
            "  EDIT fordert zum Speichern nach verlassen des\n"
            "  letzten Feldes nach unten auf.\n"
        );
        return;
    }



    if (!strcmp(cmd, "GOTO")) {
        printf(
            "\nGOTO  Datensatzzeiger setzen\n"
            "\n"
            "Syntax:\n"
            "  GOTO <nr>\n"
            "  GOTO TOP\n"
            "  Goto BOTTOM\n"
            "  GOTO PREV\n"
            "  GOTO NEXT\n"
            "\n"
            "Beschreibung:\n"
            "  Datensatzzeiger in aktueller Datenbank setzen\n"
            "  Der Datensatzzeiger wird z.B. auch in SHOW angewendet, \n"
            "  um den Beginn der Liste zu markieren. \n"
            "  Der Datensatzzeiger markiert den aktuellen Datensatz.\n"
        );
        return;
    }

    if (!strcmp(cmd, "SKIP")) {
        printf(
            "\nSKIP  Datensatzzeiger bewegen\n"
            "\n"
            "Syntax:\n"
            "  SKIP\n"
            "  SKIP <nr>\n"
            "  SKIP <-n>\n"
            "\n"
            "Beschreibung:\n"
            "  Datensatzzeiger in aktueller Datenbank bewegen\n"
            "  SKIP ohne Argument inkrementiert den Datensatzzeiger um 1."
            "  Der Datensatzzeiger wird z.B. auch in SHOW angewendet. \n"
            "  um den Beginn der Liste zu markieren. \n"
            "  Der Datensatzzeiger markiert den aktuellen Datensatz.\n"
        );
        return;
    }


    if (!strcmp(cmd, "LOCATE")) {
        printf(
            "\nLOCATE  Auswahl generieren nach Bedingung\n"
            "\n"
            "Syntax:\n"
            "  LOCATE <feld> <op> <text/zahl>\n"
            "\n"
            "Beschreibung:\n"
            "  LOCATE <feld> <text> für Characterfelder\n"
            "  LOCATE <feld> <op> <zahl> für numerische Felder\n"
            "  <feld> gueltiges Datenbakfeld\n"
            "  <op> sind < <= = >= >\n"
            "  <zahl> Dezimalpunkt statt Komma\n"
            "  Sucht das erste Vorkommen von <text> in <field> und\n"
            "  setzt den aktuellen Datensatzzeiger auf den Datensatz.\n"
            "  Der Datensatzzeiger markiert den aktuellen Datensatz.\n"
            "  Mit CONT kann der naechste Datensatz gesucht werden.\n"
        );
        return;
    }

    if (!strcmp(cmd, "CONT")) {
        printf(
            "\nCONT  Auswahl naechster Datensatz nach LOCATE\n"
            "\n"
            "Syntax:\n"
            "  CONT\n"
            "\n"
            "Beschreibung:\n"
            "  Mit CONT kann der naechste Datensatz gesucht werden.\n"
            "  CONT wird fuer eine Selektion verwendet werden,\n"
            "  die mit LOCATE erstellt wurde.\n"
            "  CONT setzt den Datensatzzeiger auf den naechsten Datensatz,\n"
            "  in der Ergebnismenge von LOCATE.\n"
        );
        return;
    }


    if (!strcmp(cmd, "SHOW")) {
        printf(
            "\nSHOW  Datensaetze anzeigen\n"
            "\n"
            "Syntax:\n"
            "  SHOW\n"
            "  SHOW ALL\n"
            "  SHOW LOC\n"
            "  SHOW <anzahl>\n"
            "  SHOW <start> <anzahl>\n"
            "  SHOW DEL\n"
            "  SHOW DEL <start> <anzahl>\n"
            "\n"
            "Beschreibung:\n"
            "  Zeigt Datensaetze der aktuellen Datenbank an.\n"
            "  SHOW alleine zeigt nur den aktuellen Datensatz\n"
            "  Anzeige erfolgt im Standard ab dem aktuellen\n"
            "  Datensatzzeiger (siehe auch GOTO, LOCATE, ...)\n"
            "  Mit SHOW ALL wird die Ausgabe ab dem Datensatz 1 begonnen.\n"
            "  Geloeschte Datensaetze werden standardmaessig\n"
            "  nicht angezeigt.\n"
            "  SHOW LOC zeigt die Ergebnisliste von LOCATE.\n"
        );
        return;
    }

    if (!strcmp(cmd, "DEL")) {
        printf(
            "\nDEL  Datensatz loeschen\n"
            "\n"
            "Syntax:\n"
            "  DEL <nr>\n"
            "\n"
            "Beschreibung:\n"
            "  Markiert einen Datensatz als geloescht.\n"
            "  Der Datensatz bleibt physisch erhalten,\n"
            "  bis PACK ausgefuehrt wird.\n"
        );
        return;
    }

    if (!strcmp(cmd, "UNDEL")) {
        printf(
            "\nUNDEL  DatensatzLoeschung rueckgaengig machen\n"
            "\n"
            "Syntax:\n"
            "  UNDEL <nr>\n"
            "\n"
            "Beschreibung:\n"
            "  Loeschmarkierung Datensatz wird entfernt.\n"
            "  Der Datensatz bleibt physisch erhalten,\n"
            "  bis PACK ausgefuehrt wird.\n"
        );
        return;
    }

    if (!strcmp(cmd, "INFO")) {
        printf(
            "\nINFO  Datenbankinformation\n"
            "\n"
            "Syntax:\n"
            "  INFO\n"
            "\n"
            "Beschreibung:\n"
            "  Zeigt Informationen zur aktuellen Datenbank\n"
        );
        return;
    }

    if (!strcmp(cmd, "CREATE")) {
        printf(
            "\nCREATE <Datei> Neue Datenbank <Datei>.DBF anlegen\n"
            "\n"
            "Syntax:\n"
            "  CREATE <Datei>\n"
            "\n"
            "Beschreibung:\n"
            "  Eine neue Datenbank wird angelegt mit dem Namen <Datei>.DBF.\n"
            "  Wenn Dateiname gueltig, wird die Datenbankstruktur angelegt\n"
            "  Zeilenweise wird Feldname, Typ, Feldlaenge, Dezimalstellen\n"
            "  erfasst. Mit RETURN in der letzten, leeren Eingabezeile wird\n"
            "  die Erfassung abgeschlossen.\n" 
            "  Mit ESC erfolgt Abbruch ohne Speichern\n"
            "  Feldname maximal 10 Zeichen, keine Sonderzeichen, kein Blank, Grossbuchstaben\n"
            "  Typ ist C (Zeichen), N (numerisch), L (logisch), D (Datum)\n"
            "  Typ C: Feldlaenge maximal 254 Zeichen\n"
            "  Typ L: Feldlaenge immer 1\n"
            "  Typ D: Feldlaenge immer 8 (jjjjmmtt)\n"
            "  Typ N: Feldlaenge inkl. Dezimalpunkt und Nachkommastellen\n"
            "  Dezimalstellen muessen in der gesamten Feldlaenge eingerechnet sein.\n"
        );
        return;
    }

    if (!strcmp(cmd, "CLS")) {
        printf(
            "\nCLS  Bildschirm loeschen\n"
            "\n"
            "Syntax:\n"
            "  CLS\n"
            "\n"
            "Beschreibung:\n"
            "  Der Bildschirm wird geloescht. Der Prompt erscheint \n"
            "  in der ersten Bildschirmzeile\n"
        );
        return;
    }

    if (!strcmp(cmd, "DIR")) {
        printf(
            "\nDIR  Inhaltsverzeichnis aktuelles Laufwerk\n"
            "\n"
            "Syntax:\n"
            "  DIR\n"
            "\n"
            "Beschreibung:\n"
            "  Es wird das Inhaltsverzeichnis des aktuellen\n"
            "  Datenlaufwerks angezeigt.\n"
        );
        return;
    }



    if (!strcmp(cmd, "CBASE")) {
        printf(
            "\nCBASE  Bedienungshinweise\n"
            "\n"
            "Beschreibung:\n"
            "  Kommandoeingabe ueber Tastatur am Prompt .\n"
            "  <RETURN> fuer Bestaetigung\n"
            "  <ESC> fuer Abbruch oder Ende von mehrzeiligen Eingaben\n"
            "  <Pfeil auf>, <Pfeil ab> fuer Befehlshistorie (max 10 Befehle)\n\n"
            "  Einschraenkungen: \n"
            "  Felder uberbeschreiten Anzeigebreite\n"
            "  Feldanzahl groesser als 23 bringen Probleme bei APPEN/EDIT/INSERT\n"
            "  Datenbank ist komplett im Arbeitsspeicher\n\n"
            "  Das ist ein Retro-Projekt und kein kommerzielles System\n"
            "  Es dient dem Lernen der Programmiersprache C auf dem NKC 68000.\n"
        );
        return;
    }

     if (!strcmp(cmd, "PROJEKT")) {
        printf(
            "Beschreibung:\n"
            "CBASE ist ein freies, eigenstaendig entwickeltes Datenbanksystem fuer den NKC,\n"
            "inspiriert von klassischen dBase-Systemen der 1980er Jahre (dBase II / III).\n\n"

            "Ziel des Projekts ist, die Funktionsweise frueher datenbankbasierter Anwendungen\n"
            "auf Retro-Hardware nachvollziehbar, erlernbar und erweiterbar zu machen, \n"
            "nicht die exakte Nachbildung oder Emulation eines kommerziellen Produkts.\n\n"
            "Abgrenzung:\n"
            "CBASE ist keine Portierung, Emulation oder Rekonstruktion von dBase II, \n"
            "dBase III oder verwandter kommerzieller Software.\n"
            "Es wurde kein Original-Quellcode verwendet. Es wurden keine Binaerformate oder\n"
            "Routinen uebernommen. Die Entwicklung erfolgte ausschliesslich auf Basis:\n"
            "   oeffentlich dokumentierter Dateiformate (DBF)\n"
            "   historischer Literatur\n"
            "   eigener Analyse\n"
            "   praktischer Erfahrung und Erinnerung an fruehere Systeme\n\n"
            "CBASE ist eine eigenstaendige Neuentwicklung, die sich konzeptionell\n"
            "an der Arbeitsweise historischer Datenbanksysteme orientiert.\n"
         );
        return;
    }


    
    printf("\nKeine Hilfe zu diesem Kommando verfuegbar.\n");
}

