// MESSAGES.H Meldungstexte

#ifndef MESSAGES_H
#define MESSAGES_H

#define MSG_HELP_FOR    "\r\nHELP for help...\r\n"

#define MSG_UNKNOWN_COMMAND "\nUnknown command\n"

// USE
#define MSG_DB_USE_DB       "\nUSAGE: USE <filename>\n"
#define MSG_NO_DB           "\nNo database open\n"
#define MSG_DB_OPENED       "\nDatabase opened\n"
#define MSG_BAD_RECORD      "\nInvalid record number\n"
#define MSG_DB_ALREADY_OPEN "\nDatabase already open\n"
#define MSG_DB_OPEN_OK      "\nOK\n"
#define MSG_DB_DIRTY_WARNING "Database modified but not saved. Continue and lose changes?"

//SAVE
#define MSG_DB_OK           "\nOK\n"
#define MSG_DB_SAVED        "\nDatabase saved\n"
#define MSG_DB_NOT_SAVED    "\nDatabase not saved\n"

// PACK
#define MSG_PACK_QUESTION   "PACK removes deleted records permanently "
#define MSG_PACK_ABORTED    "PACK aborted.\r\n"
#define MSG_PACK_NO_PACK    "No deleted records.\r\n"

// COPY
#define MSG_DB_COPY_DB      "\nUSAGE: COPY [LOC] <filename>\n"
#define MSG_DB_COPY_EXISTS  "\nFile exists - overwrite? "
#define MSG_DB_COPY_CANCEL  "\nCOPY Canceled\n"
#define MSG_DB_COPIED       "\nDatabase copied\n"
#define MSG_DB_NOT_COPIED   "\nCOPY failed\n"
#define MSG_DB_NOT_VALID    "\nInvalid database name\n"
#define MSG_DB_COPY_LOG_OK  "\nLOC Results copied\r\n"
#define MSG_DB_COPY_LOC_FAILED "\nCOPY LOC failed\r\n"

// GOTO
#define MSG_GOTO_REQ_ARG    "USAGE: GOTO <recno> or TOP, BOTTOM, PREV, NEXT"
#define MSG_EOF             "\nEnd of Database\n"
#define MSG_NO_RECORDS      "\nNo records\n"

//LOCATE und CONT
#define MSG_LOCATE_REQ_ARG  "USAGE: LOCATE <field> <text>\n"
#define MSG_LOCATE_MISSING_ARG     "Missing Search String\n"
#define MSG_LOCATE_FOUND    "Found: "
#define MSG_LOCATE_NOT_FOUND "Nothing found, end of LOCATE\n"
#define MSG_LOCATE_UNKNOWN_FIELD  "Unknown field: "
#define MSG_CONT_NO_LOCATE  "No active Locate\n"
#define MSG_CONT_EOF        "End of file, no more matches.\n"
#define MSG_LOCATE_FIELD_TYPE "LOCATE unsupported fieldtype\n"

// SHOW
#define MSG_SHOW_PAGE       "-- more -- (RETURN=weiter, ESC=abbruch) "
#define MSG_SHOW_NO_LOCATE  "No active LOCATE\r\n"

// EXPORT
#define MSG_EXPORT_ARG      "USAGE: EXPORT [ALL]|[LOC] <filename>\r\n"
#define MSG_EXPORT_MISSING_FILE "No Filename\r\n"
#define MSG_EXPORT_NO_LOCATE "No active Locate\r\n"
#define MSG_EXPORT_OK       "Export saved\r\n"
#define MSG_EXPORT_NOT_OK   "Export failed\r\n"

// SORT
#define MSG_SORT_ARG        "USAGE: SORT ON <field> TO <dbname> [DESC]\n"
#define MSG_SORT_ARG_ON     "SORT requires ON\n"
#define MSG_SORT_ARG_TO     "SORT requires TO\n"
#define MSG_SORT_FAILED     "SORT failed\n"


// APPEND
#define MSG_DB_NO_SPACE     "No place in structure for APPEND\n"
#define MSG_APPEND_ADD_ANOTHER         "Add another record "
#define MSG_APPEND_REC_NOT_SAVED "Record not saved\r\n"
#define MSG_APPEND_SAVE_RECORD "Save record?"

// EDIT

#define MSG_EDIT_SAVE_RECORD "Save record?"

// DEL
#define MSG_NOT_DEL         "\nRecord not deleted\n"
#define MSG_DEL_OK          "\nRecord deleted\n"
#define MSG_UNDEL_OK        "\nRecord restored\n"


//UNDEL
#define MSG_UNDEL_REQ_NUM   "\nUNDEL requires record number\n"

//CREATE
#define MSG_CREATE_CANCEL   "CREATE cancelled\r\n"
#define MSG_CREATE_TOO_MANY_FIELDS  "Too many fields\r\n"
#define MSG_CREATE_INVALID_FIELD "Invalid field definition\r\n"
#define MSG_CREATE_VALID_FIELD "Field accepted\r\n"
#define MSG_CREATE_DB_CREATED  "Database created\n"
#define MSG_CREATE_DB_NOT_CREATED "Database not created - Failure!\n"


#endif
