/* RECORD.H Header für APPEND, INSERT, EDIT*/

#ifndef RECORD_H
#define RECORD_H


#include "cbase.h"
#include "db.h"
#include "util.h"


// Bildschirmtest
void test_screen_input(void);

// INSERT, APPEND, EDIT
int db_append_record(db_t *db);
int db_insert(db_t *db, uint32_t insert_pos);
int db_edit_record(db_t *db, uint32_t recno);


// Hilfsfunktionen INSERT, APPEND, EDIT

int db_input_field(db_t *db, const dbf_field_t *field, uint8_t *rec, input_mode_t mode);


int format_numeric(const char *in, char *out, unsigned width, unsigned decimals);

int format_date(const char *in, char *out);

int append_read_field(
    char *buf,
    int maxlen,
    int (*valid_char)(int ch)
);

int valid_char_c(int ch);

int valid_char_n(int ch);

int valid_char_l(int ch);

int valid_char_d(int ch);



void print_field_prompt(const char *name);
void clear_status_line(void);

void edit_draw_field(const dbf_field_t *f, const uint8_t *rec, uint8_t y);
int parse_date_input(const char *in, char *out_yyyymmdd);
int edit_input_field(const dbf_field_t *f, uint8_t *rec, uint8_t y);


// GDP Funktionen

// Umrechnung Grafikauflösung in Zeilen und Spalten 
// Spalten: 512 / 6 = 80 (0...79), 
// Zeilen(32): 256 / 8 = 32 (0...31)
// Zeilen(25): 256 / 10 = 25 (0...24)
// Ursprung Zeile / Spalte unten links
#define CCNV_X(X) (((uint16_t)X)*6u)
#define CCNV_Y(Y) (((uint16_t)Y)*10u-4)


// Bildschirmsteuerung
// Schreibt auf den zwei ersten Bildschirmseiten
// Wird benötigt, dass blikender Cursor funktioniert
// gp_writexy schreibt in Bildschirmkoordinaten (512x256 Pixel)
static inline __attribute__((always_inline)) void WriteScreenxy(uint16_t x, uint16_t y,const char* const p_str)
{
   // Koordinaten umrechnen für Texteingabe mit Format Zeile 0 - 23 von Ursprung oben links
   y = abs(y-24)+1;
   for(uint8_t page=0u;page<2u; page++) {
      // Text schreiben auf Seite 0 und 1 (wegen blinkendem Cursor)
      gp_newpage(page,0u);
      gp_writexy(CCNV_X(x),CCNV_Y(y),0x11, p_str);
   }   
}

// Setzen des Bildschirmcursors
// gp_setcurxy setzt Cursor in Textzeilen
static inline __attribute__((always_inline)) void SetCursorxy(uint8_t x, uint8_t y)
{
   gp_setcurxy(x,y);
}






#endif
