// SORT.H
#ifndef SORT_H
#define SORT_H

#define SORT_MAX_KEYS 8

typedef struct {
    int field_index;
    int descending;
} sort_key_t;

typedef struct {
    db_t       *db;
    int         key_count;
    sort_key_t  keys[SORT_MAX_KEYS];
} sort_ctx_t;

int db_sort_cmp(const void *a, const void *b);

int db_sort_prepare(db_t *db, const sort_key_t *keys, int key_count, uint32_t **out_index, uint32_t *out_count);

int db_sort_to_file(db_t *src, const char *dest_name, const uint32_t *idx, uint32_t count);

#endif
