/* UTIL.H */

#ifndef UTIL_H
#define UTIL_H

#include <stdint.h>

/* weitere util-Funktionen */


/* --- Endian-Hilfsfunktionen (68000 = Big Endian, DBF = Little Endian) --- */

uint16_t from_le16(uint16_t v);
uint32_t from_le32(uint32_t v);
uint16_t to_le16(uint16_t v);
uint32_t to_le32(uint32_t v);
void db_header_to_le(dbf_header_t *h);



/* String helpers */
void util_str_toupper(char *s); /* Inplace Uppercase*/
char util_toupper(char c); /* Uppercase Zeichenweise mit Rückgabe*/
void util_trim(char *s);
unsigned util_copy_trimmed(char *dst, const uint8_t *src, unsigned len);
void util_print_field_trimmed(const uint8_t *p, unsigned len);

/* Date helper*/
void format_date_display(const uint8_t *rec, int offset, char *out);

/* Parsing helpers */
int  util_starts_with(const char *s, const char *prefix);

int is_valid_db_name(const char *name);

void util_dir_drive(const char *pattern);

int ask_yes_no(const char *prompt);
int wait_continue_or_quit(void);


/* Utilities */
void make_db_filename(char *dst, size_t dstlen, const char *name);
void make_csv_filename(char *out, size_t len, const char *name);


// aktuelle Datensatznummer ausgeben
void print_current_record(db_t *db);




// Komando Historie
#define HIST_MAX   10


void history_add(const char *line);
int  read_line_ci(char *buf, int maxlen);


#endif
